/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.diff.pictures;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.diff.pictures.DiffPictures;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.web.common.ServletHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DiffPicturesServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DiffPicturesServlet.class);
    protected static final int BUFFER_SIZE = 524288;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String leftDocId = req.getParameter("leftDocId");
        String rightDocId = req.getParameter("rightDocId");
        if (StringUtils.isBlank((CharSequence)leftDocId)) {
            this.sendTextResponse(resp, "you must specify a left document as origin");
            return;
        }
        if (StringUtils.isBlank((CharSequence)rightDocId)) {
            this.sendTextResponse(resp, "you must specify 'right' used for comparison against the left document.");
            return;
        }
        TransactionHelper.runInTransaction(() -> {
            String repo = req.getParameter("repo");
            String xpath = req.getParameter("xpath");
            String commandLine = req.getParameter("commandLine");
            String fuzz = req.getParameter("fuzz");
            String highlightColor = req.getParameter("highlightColor");
            String lowlightColor = req.getParameter("lowlightColor");
            String altExtension = req.getParameter("altExtension");
            if (StringUtils.isBlank((CharSequence)repo)) {
                repo = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepository().getName();
            }
            try (CloseableCoreSession coreSession = CoreInstance.openCoreSession((String)repo);){
                Blob bResult;
                DocumentModel leftDoc = coreSession.getDocument((DocumentRef)new IdRef(leftDocId));
                DocumentModel rightDoc = coreSession.getDocument((DocumentRef)new IdRef(rightDocId));
                DiffPictures dp = new DiffPictures(leftDoc, rightDoc, xpath);
                HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                if (StringUtils.isNotBlank((CharSequence)fuzz)) {
                    params.put("fuzz", (Serializable)((Object)fuzz));
                }
                if (StringUtils.isNotBlank((CharSequence)highlightColor)) {
                    params.put("highlightColor", (Serializable)((Object)highlightColor));
                }
                if (StringUtils.isNotBlank((CharSequence)lowlightColor)) {
                    params.put("lowlightColor", (Serializable)((Object)lowlightColor));
                }
                if (StringUtils.isNotBlank((CharSequence)altExtension)) {
                    Blob leftB = StringUtils.isBlank((CharSequence)xpath) || "null".equals(xpath) ? (Blob)leftDoc.getPropertyValue("file:content") : (Blob)leftDoc.getPropertyValue(xpath);
                    String fileName = leftB.getFilename();
                    int dotPos = fileName.lastIndexOf(".");
                    String ext = fileName.substring(dotPos + 1);
                    switch (ext = ext.toLowerCase()) {
                        case "jpg": 
                        case "jpeg": 
                        case "png": 
                        case "gif": {
                            break;
                        }
                        default: {
                            if (altExtension.indexOf(".") != 0) {
                                altExtension = "." + altExtension;
                            }
                            fileName = "comp-" + fileName + altExtension;
                            params.put("targetFileName", (Serializable)((Object)fileName));
                        }
                    }
                }
                try {
                    bResult = dp.compare(commandLine, params);
                }
                catch (IOException | CommandNotAvailable e) {
                    log.error((Object)"Unable to compare the pictures", e);
                    try {
                        this.sendTextResponse(resp, "Unable to compare the pictures");
                    }
                    catch (IOException e1) {
                        throw new NuxeoException((Throwable)e1);
                    }
                    if (coreSession != null) {
                        if (var13_13 != null) {
                            try {
                                coreSession.close();
                            }
                            catch (Throwable e1) {
                                var13_13.addSuppressed(e1);
                            }
                        } else {
                            coreSession.close();
                        }
                    }
                    return;
                }
                resp.setHeader("Cache-Control", "no-cache");
                resp.setHeader("Pragma", "no-cache");
                try {
                    this.sendBlobResult(req, resp, bResult);
                }
                catch (IOException e) {
                    log.error((Object)"Unable to handleCompareResult", (Throwable)e);
                    try {
                        this.sendTextResponse(resp, "Unable to return the result");
                    }
                    catch (IOException e1) {
                        throw new NuxeoException((Throwable)e1);
                    }
                    if (coreSession != null) {
                        if (var13_13 != null) {
                            try {
                                coreSession.close();
                            }
                            catch (Throwable throwable) {
                                var13_13.addSuppressed(throwable);
                            }
                        } else {
                            coreSession.close();
                        }
                    }
                    return;
                }
            }
        });
    }

    protected void sendTextResponse(HttpServletResponse resp, String response) throws IOException {
        resp.setContentType("text/plain");
        resp.setContentLength(response.getBytes().length);
        ServletOutputStream out = resp.getOutputStream();
        out.write(response.getBytes());
        out.close();
    }

    protected void sendBlobResult(HttpServletRequest req, HttpServletResponse resp, Blob blob) throws IOException {
        int bytesRead;
        InputStream in = blob.getStream();
        ServletOutputStream out = resp.getOutputStream();
        String fileName = blob.getFilename();
        resp.setHeader("Content-Disposition", ServletHelper.getRFC2231ContentDisposition((HttpServletRequest)req, (String)fileName));
        resp.setContentType(blob.getMimeType());
        long fileSize = blob.getLength();
        resp.setContentLength((int)fileSize);
        byte[] buffer = new byte[524288];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }
}

