/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.seam;

import java.io.File;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.hierarchy.userworkspace.adapter.UserWorkspaceHelper;
import org.nuxeo.drive.seam.DesktopPackageDefinition;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.security.SecurityException;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.ecm.user.center.UserCenterViewManager;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="nuxeoDriveActions")
@Scope(value=ScopeType.PAGE)
@Install(precedence=10)
public class NuxeoDriveActions
extends InputController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(NuxeoDriveActions.class);
    protected static final String IS_UNDER_SYNCHRONIZATION_ROOT = "nuxeoDriveIsUnderSynchronizationRoot";
    protected static final String CURRENT_SYNCHRONIZATION_ROOT = "nuxeoDriveCurrentSynchronizationRoot";
    public static final String NXDRIVE_PROTOCOL = "nxdrive";
    public static final String PROTOCOL_COMMAND_EDIT = "edit";
    public static final String UPDATE_SITE_URL_PROP_KEY = "org.nuxeo.drive.update.site.url";
    public static final String SERVER_VERSION_PROP_KEY = "org.nuxeo.ecm.product.version";
    public static final String DESKTOP_PACKAGE_URL_LATEST_SEGMENT = "latest";
    public static final String DESKTOP_PACKAGE_PREFIX = "nuxeo-drive.";
    public static final String MSI_EXTENSION = "msi";
    public static final String DMG_EXTENSION = "dmg";
    public static final String WINDOWS_PLATFORM = "windows";
    public static final String OSX_PLATFORM = "osx";
    private static final String DRIVE_METADATA_VIEW = "view_drive_metadata";
    @In(create=true, required=false)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient UserCenterViewManager userCenterViews;
    @In(create=true)
    protected transient DocumentActions documentActions;

    @Factory(value="nuxeoDriveCurrentSynchronizationRoot", scope=ScopeType.EVENT)
    public DocumentModel getCurrentSynchronizationRoot() throws ClientException {
        Context cache = Contexts.getEventContext();
        Boolean isUnderSync = (Boolean)cache.get(IS_UNDER_SYNCHRONIZATION_ROOT);
        if (isUnderSync == null) {
            NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
            Set references = driveManager.getSynchronizationRootReferences(this.documentManager);
            DocumentModelList path = this.navigationContext.getCurrentPath();
            DocumentModel root = null;
            for (DocumentModel parent : path) {
                if (!references.contains(parent.getRef())) continue;
                root = parent;
                break;
            }
            cache.set(CURRENT_SYNCHRONIZATION_ROOT, root);
            cache.set(IS_UNDER_SYNCHRONIZATION_ROOT, (Object)(root != null ? 1 : 0));
        }
        return (DocumentModel)cache.get(CURRENT_SYNCHRONIZATION_ROOT);
    }

    public boolean canEditDocument(DocumentModel doc) throws ClientException {
        if (doc == null) {
            return false;
        }
        if (doc.isFolder()) {
            return false;
        }
        if (!this.documentManager.hasPermission(doc.getRef(), "Write")) {
            return false;
        }
        return this.getFileSystemItem(doc) != null;
    }

    public boolean hasOneDriveToken(Principal user) {
        TokenAuthenticationService tokenService = (TokenAuthenticationService)Framework.getLocalService(TokenAuthenticationService.class);
        for (DocumentModel token : tokenService.getTokenBindings(user.getName())) {
            if (!"Nuxeo Drive".equals(token.getPropertyValue("authtoken:applicationName"))) continue;
            return true;
        }
        return false;
    }

    public String getDriveEditURL() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        BlobHolder bh = (BlobHolder)currentDocument.getAdapter(BlobHolder.class);
        if (bh == null) {
            throw new ClientException(String.format("Document %s (%s) is not a BlobHolder, cannot get Drive Edit URL.", currentDocument.getPathAsString(), currentDocument.getId()));
        }
        Blob blob = bh.getBlob();
        if (blob == null) {
            throw new ClientException(String.format("Document %s (%s) has no blob, cannot get Drive Edit URL.", currentDocument.getPathAsString(), currentDocument.getId()));
        }
        String fileName = blob.getFilename();
        ServletRequest servletRequest = (ServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        String baseURL = VirtualHostHelper.getBaseURL((ServletRequest)servletRequest);
        StringBuffer sb = new StringBuffer();
        sb.append(NXDRIVE_PROTOCOL).append("://");
        sb.append(PROTOCOL_COMMAND_EDIT).append("/");
        sb.append(baseURL.replaceFirst("://", "/"));
        sb.append("repo/");
        sb.append(this.documentManager.getRepositoryName());
        sb.append("/nxdocid/");
        sb.append(currentDocument.getId());
        sb.append("/filename/");
        String escapedFilename = fileName.replaceAll("(/|\\\\|\\*|<|>|\\?|\"|:|\\|)", "-");
        sb.append(URIUtils.quoteURIPathComponent((String)escapedFilename, (boolean)true));
        return sb.toString();
    }

    public String navigateToUserCenterNuxeoDrive() {
        return this.getUserCenterNuxeoDriveView();
    }

    @Factory(value="canSynchronizeCurrentDocument")
    public boolean canSynchronizeCurrentDocument() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return false;
        }
        return this.isSyncRootCandidate(currentDocument) && this.getCurrentSynchronizationRoot() == null;
    }

    @Factory(value="canUnSynchronizeCurrentDocument")
    public boolean canUnSynchronizeCurrentDocument() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return false;
        }
        if (!this.isSyncRootCandidate(currentDocument)) {
            return false;
        }
        DocumentRef currentDocRef = currentDocument.getRef();
        DocumentModel currentSyncRoot = this.getCurrentSynchronizationRoot();
        if (currentSyncRoot == null) {
            return false;
        }
        return currentDocRef.equals(currentSyncRoot.getRef());
    }

    @Factory(value="canNavigateToCurrentSynchronizationRoot")
    public boolean canNavigateToCurrentSynchronizationRoot() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return false;
        }
        if ("deleted".equals(currentDocument.getCurrentLifeCycleState())) {
            return false;
        }
        DocumentRef currentDocRef = currentDocument.getRef();
        DocumentModel currentSyncRoot = this.getCurrentSynchronizationRoot();
        if (currentSyncRoot == null) {
            return false;
        }
        return !currentDocRef.equals(currentSyncRoot.getRef());
    }

    @Factory(value="currentDocumentUserWorkspace", scope=ScopeType.PAGE)
    public boolean isCurrentDocumentUserWorkspace() throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument == null) {
            return false;
        }
        return UserWorkspaceHelper.isUserWorkspace((DocumentModel)currentDocument);
    }

    public String synchronizeCurrentDocument() throws ClientException, SecurityException {
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
        Principal principal = this.documentManager.getPrincipal();
        DocumentModel newSyncRoot = this.navigationContext.getCurrentDocument();
        driveManager.registerSynchronizationRoot(principal, newSyncRoot, this.documentManager);
        boolean hasOneNuxeoDriveToken = this.hasOneDriveToken(principal);
        if (hasOneNuxeoDriveToken) {
            return null;
        }
        return this.getUserCenterNuxeoDriveView();
    }

    public void unsynchronizeCurrentDocument() throws ClientException {
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
        Principal principal = this.documentManager.getPrincipal();
        DocumentModel syncRoot = this.navigationContext.getCurrentDocument();
        driveManager.unregisterSynchronizationRoot(principal, syncRoot, this.documentManager);
    }

    public String navigateToCurrentSynchronizationRoot() throws ClientException {
        DocumentModel currentRoot = this.getCurrentSynchronizationRoot();
        if (currentRoot == null) {
            return "";
        }
        return this.navigationContext.navigateToDocument(currentRoot);
    }

    public DocumentModelList getSynchronizationRoots() throws ClientException {
        DocumentModelListImpl syncRoots = new DocumentModelListImpl();
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
        Set syncRootRefs = driveManager.getSynchronizationRootReferences(this.documentManager);
        for (IdRef syncRootRef : syncRootRefs) {
            syncRoots.add((Object)this.documentManager.getDocument((DocumentRef)syncRootRef));
        }
        return syncRoots;
    }

    public void unsynchronizeRoot(DocumentModel syncRoot) throws ClientException {
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
        Principal principal = this.documentManager.getPrincipal();
        driveManager.unregisterSynchronizationRoot(principal, syncRoot, this.documentManager);
    }

    @Factory(value="nuxeoDriveClientPackages", scope=ScopeType.CONVERSATION)
    public List<DesktopPackageDefinition> getClientPackages() {
        ArrayList<DesktopPackageDefinition> packages = new ArrayList<DesktopPackageDefinition>();
        Object desktopPackageBaseURL = Component.getInstance((String)"desktopPackageBaseURL", (ScopeType)ScopeType.APPLICATION);
        if (desktopPackageBaseURL != ObjectUtils.NULL) {
            String packageName = "nuxeo-drive.dmg";
            String packageURL = desktopPackageBaseURL + packageName;
            packages.add(new DesktopPackageDefinition(packageURL, packageName, OSX_PLATFORM));
            log.debug((Object)String.format("Added %s to the list of desktop packages available for download.", packageURL));
            packageName = "nuxeo-drive.msi";
            packageURL = desktopPackageBaseURL + packageName;
            packages.add(new DesktopPackageDefinition(packageURL, packageName, WINDOWS_PLATFORM));
            log.debug((Object)String.format("Added %s to the list of desktop packages available for download.", packageURL));
        }
        packages.add(new DesktopPackageDefinition("https://github.com/nuxeo/nuxeo-drive/#ubuntudebian-and-other-linux-variants-client", "user.center.nuxeoDrive.platform.ubuntu.docLinkTitle", "ubuntu"));
        return packages;
    }

    @Factory(value="desktopPackageBaseURL", scope=ScopeType.APPLICATION)
    public Object getDesktopPackageBaseURL() {
        String URL2 = Framework.getProperty((String)UPDATE_SITE_URL_PROP_KEY);
        if (URL2 == null) {
            return ObjectUtils.NULL;
        }
        StringBuilder sb = new StringBuilder(URL2);
        if (!URL2.endsWith("/")) {
            sb.append("/");
        }
        sb.append(DESKTOP_PACKAGE_URL_LATEST_SEGMENT);
        sb.append("/");
        sb.append(Framework.getProperty((String)SERVER_VERSION_PROP_KEY));
        sb.append("/");
        return sb.toString();
    }

    public String downloadClientPackage(String name, File file) {
        FacesContext facesCtx = FacesContext.getCurrentInstance();
        return ComponentUtils.downloadFile((FacesContext)facesCtx, (String)name, (File)file);
    }

    protected boolean isSyncRootCandidate(DocumentModel doc) throws ClientException {
        if (!doc.isFolder()) {
            return false;
        }
        return !"deleted".equals(doc.getCurrentLifeCycleState());
    }

    protected FileSystemItem getFileSystemItem(DocumentModel doc) throws ClientException {
        FileSystemItem fileSystemItem = ((FileSystemItemAdapterService)Framework.getLocalService(FileSystemItemAdapterService.class)).getFileSystemItem(doc, null);
        if (fileSystemItem == null) {
            log.debug((Object)String.format("Document %s (%s) is not adaptable as a FileSystemItem.", doc.getPathAsString(), doc.getId()));
        }
        return fileSystemItem;
    }

    protected String getUserCenterNuxeoDriveView() {
        this.userCenterViews.setCurrentViewId("userCenterNuxeoDrive");
        return "view_home";
    }

    public String updateCurrentDocument() throws ClientException {
        this.documentActions.updateCurrentDocument();
        return DRIVE_METADATA_VIEW;
    }
}

