/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.operations.NuxeoDriveOperationHelper;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.CreateFile", category="Services", label="Nuxeo Drive: Create file")
public class NuxeoDriveCreateFile {
    public static final String ID = "NuxeoDrive.CreateFile";
    @Context
    protected OperationContext ctx;
    @Param(name="id")
    protected String id;

    @OperationMethod
    public Blob run(Blob blob) throws Exception {
        FileSystemItemManager fileSystemItemManager = (FileSystemItemManager)Framework.getLocalService(FileSystemItemManager.class);
        NuxeoDriveOperationHelper.normalizeMimeTypeAndEncoding(blob);
        FileItem fileItem = fileSystemItemManager.createFile(this.id, blob, this.ctx.getPrincipal());
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)fileItem);
        return StreamingBlob.createFromString((String)writer.toString(), (String)"application/json");
    }
}

