/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.impl.FileSystemChangeSummary;
import org.nuxeo.drive.service.impl.RootDefinitionsHelper;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.GetChangeSummary", category="Services", label="Nuxeo Drive: Get change summary")
public class NuxeoDriveGetChangeSummary {
    public static final String ID = "NuxeoDrive.GetChangeSummary";
    @Context
    protected OperationContext ctx;
    @Param(name="lastSyncDate", required=false)
    protected Long lastSyncDate = -1L;
    @Param(name="lastSyncActiveRootDefinitions", required=false)
    protected String lastSyncActiveRootDefinitions;

    @OperationMethod
    public Blob run() throws Exception {
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
        Map lastActiveRootRefs = RootDefinitionsHelper.parseRootDefinitions((String)this.lastSyncActiveRootDefinitions);
        FileSystemChangeSummary docChangeSummary = driveManager.getChangeSummary(this.ctx.getPrincipal(), lastActiveRootRefs, this.lastSyncDate.longValue());
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)docChangeSummary);
        return StreamingBlob.createFromString((String)writer.toString(), (String)"application/json");
    }
}

