/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import java.io.StringWriter;
import java.io.Writer;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.Move", category="Services", label="Nuxeo Drive: Move")
public class NuxeoDriveMove {
    public static final String ID = "NuxeoDrive.Move";
    @Context
    protected OperationContext ctx;
    @Param(name="srcId")
    protected String srcId;
    @Param(name="destId")
    protected String destId;

    @OperationMethod
    public Blob run() throws Exception {
        FileSystemItemManager fileSystemItemManager = (FileSystemItemManager)Framework.getLocalService(FileSystemItemManager.class);
        FileSystemItem fsItem = fileSystemItemManager.move(this.srcId, this.destId, this.ctx.getPrincipal());
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)fsItem);
        return StreamingBlob.createFromString((String)writer.toString(), (String)"application/json");
    }
}

