/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations.test;

import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public final class NuxeoDriveIntegrationTestsHelper {
    static final String TEST_USER_NAME_PREFIX = "nuxeoDriveTestUser_";
    static final String TEST_WORKSPACE_PARENT_PATH = "/default-domain/workspaces";
    static final String TEST_WORKSPACE_NAME = "nuxeo-drive-test-workspace";
    static final String TEST_WORKSPACE_TITLE = "Nuxeo Drive Test Workspace";
    public static final String TEST_WORKSPACE_PATH = "/default-domain/workspaces/nuxeo-drive-test-workspace";
    public static final String USER_WORKSPACE_PARENT_PATH = "/default-domain/UserWorkspaces";

    private NuxeoDriveIntegrationTestsHelper() {
    }

    public static void cleanUp(CoreSession session) throws Exception {
        UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
        DocumentModelList testUsers = userManager.searchUsers(TEST_USER_NAME_PREFIX);
        for (DocumentModel testUser : testUsers) {
            String testUserName = (String)((Object)testUser.getPropertyValue(userManager.getUserSchemaName() + ":" + userManager.getUserIdField()));
            if (userManager.getPrincipal(testUserName) != null) {
                userManager.deleteUser(testUserName);
            }
            String testUserWorkspaceName = IdUtils.generateId((String)testUserName, (String)"-", (boolean)false, (int)30);
            PathRef testUserWorkspaceRef = new PathRef("/default-domain/UserWorkspaces/" + testUserWorkspaceName);
            if (!session.exists((DocumentRef)testUserWorkspaceRef)) continue;
            session.removeDocument((DocumentRef)testUserWorkspaceRef);
        }
        PathRef testWorkspaceDocRef = new PathRef(TEST_WORKSPACE_PATH);
        if (session.exists((DocumentRef)testWorkspaceDocRef)) {
            session.removeDocument((DocumentRef)testWorkspaceDocRef);
        }
    }
}

