/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations.test;

import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.drive.operations.NuxeoDriveOperationHelper;
import org.nuxeo.drive.operations.test.NuxeoDriveIntegrationTestsHelper;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

@Operation(id="NuxeoDrive.SetupIntegrationTests", category="Services", label="Nuxeo Drive: Setup integration tests")
public class NuxeoDriveSetupIntegrationTests {
    public static final String ID = "NuxeoDrive.SetupIntegrationTests";
    @Context
    protected CoreSession session;
    @Param(name="userNames")
    protected String userNames;
    @Param(name="permission")
    protected String permission;
    @Param(name="useMembersGroup", required=false)
    protected boolean useMembersGroup = false;

    @OperationMethod
    public Blob run() throws ClientException {
        NuxeoDriveIntegrationTestsHelper.checkOperationAllowed();
        NuxeoDriveIntegrationTestsHelper.cleanUp(this.session);
        String[] userNamesArray = StringUtils.split((String)this.userNames, (String)",");
        String[] prefixedUserNames = new String[userNamesArray.length];
        for (int i = 0; i < userNamesArray.length; ++i) {
            prefixedUserNames[i] = "nuxeoDriveTestUser_" + userNamesArray[i].trim();
        }
        String testUserCredentials = this.createTestUsers(prefixedUserNames);
        this.createTestWorkspace(prefixedUserNames);
        NuxeoDriveOperationHelper.commitAndReopenTransaction();
        return StreamingBlob.createFromString((String)testUserCredentials, (String)"text/plain");
    }

    protected String createTestUsers(String[] testUserNames) throws ClientException {
        StringBuilder testUserCredentials = new StringBuilder();
        UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        String userSchemaName = userManager.getUserSchemaName();
        String userNameField = directoryService.getDirectoryIdField(userManager.getUserDirectoryName());
        String passwordField = directoryService.getDirectoryPasswordField(userManager.getUserDirectoryName());
        for (int i = 0; i < testUserNames.length; ++i) {
            String testUserName = testUserNames[i];
            String testUserPassword = UUID.randomUUID().toString().substring(0, 6);
            DocumentModel testUserModel = userManager.getBareUserModel();
            testUserModel.setProperty(userSchemaName, userNameField, (Object)testUserName);
            testUserModel.setProperty(userSchemaName, passwordField, (Object)testUserPassword);
            if (this.useMembersGroup) {
                testUserModel.setProperty(userSchemaName, "groups", (Object)new String[]{"members"});
            }
            userManager.createUser(testUserModel);
            testUserCredentials.append(testUserName);
            testUserCredentials.append(":");
            testUserCredentials.append(testUserPassword);
            if (i >= testUserNames.length - 1) continue;
            testUserCredentials.append(",");
        }
        return testUserCredentials.toString();
    }

    protected void createTestWorkspace(String[] testUserNames) throws ClientException {
        String testWorkspaceParentPath = NuxeoDriveIntegrationTestsHelper.getDefaultDomainPath(this.session) + "/" + "workspaces";
        DocumentModel testWorkspace = this.session.createDocumentModel(testWorkspaceParentPath, "nuxeo-drive-test-workspace", "Workspace");
        testWorkspace.setPropertyValue("dc:title", (Serializable)((Object)"Nuxeo Drive Test Workspace"));
        this.session.createDocument(testWorkspace);
        String testWorkspacePath = testWorkspaceParentPath + "/" + "nuxeo-drive-test-workspace";
        PathRef testWorkspaceDocRef = new PathRef(testWorkspacePath);
        ACP acp = this.session.getACP((DocumentRef)testWorkspaceDocRef);
        ACL localACL = acp.getOrCreateACL("local");
        for (String testUserName : testUserNames) {
            localACL.add((Object)new ACE(testUserName, this.permission, true));
        }
        this.session.setACP((DocumentRef)testWorkspaceDocRef, acp, false);
    }
}

