/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.factory;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.spaces.api.Gadget;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.SpaceManager;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceException;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceNotFoundException;
import org.nuxeo.opensocial.container.client.bean.Container;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;
import org.nuxeo.opensocial.container.factory.api.ContainerManager;
import org.nuxeo.opensocial.container.factory.mapping.GadgetMapper;
import org.nuxeo.opensocial.container.factory.utils.CoreSessionHelper;
import org.nuxeo.opensocial.container.factory.utils.PermissionHelper;
import org.nuxeo.opensocial.gadgets.service.api.GadgetService;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerManagerImpl
implements ContainerManager {
    private static final Log log = LogFactory.getLog(ContainerManagerImpl.class);
    public static final String DOC_REF = "docRef";
    public static final String REPO_NAME = "repoName";
    private static final String LAYOUT_PREFIX = "x-";
    private static final String LAYOUT_SEPARATOR = "-";
    public static final int DEFAULT_STRUCTURE = 3;
    public static final String DEFAULT_LAYOUT = "x-3-default";
    private int shindigId = 0;

    public Container createContainer(Map<String, String> containerParams) throws ClientException {
        String spaceId = this.getParamValue(DOC_REF, containerParams, true, null);
        String repositoryName = this.getParamValue(REPO_NAME, containerParams, false, "default");
        CoreSession session = this.getCoreSession(containerParams);
        if (session != null) {
            try {
                return this.createContainer(((SpaceManager)Framework.getService(SpaceManager.class)).getSpaceFromId(spaceId, session), session);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            log.error((Object)("Unable to get core session from repository name '" + repositoryName + "'."));
        }
        return null;
    }

    protected CoreSession getCoreSession(Map<String, String> containerParams) throws ClientException {
        try {
            return CoreSessionHelper.getCoreSession(containerParams.get(REPO_NAME));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ClientException();
        }
    }

    private String getParamValue(String key, Map<String, String> containerParams, boolean required, String defaultValue) {
        String value = containerParams.get(key);
        String retour = null;
        if (value == null) {
            if (required) {
                throw new RuntimeException("Container param for key '" + key + "' is required");
            }
            retour = defaultValue;
        } else {
            retour = value;
        }
        return retour;
    }

    private int getStructure(Space space) {
        int structure = 3;
        if (space.getLayout() != null) {
            try {
                StringTokenizer st = new StringTokenizer(space.getLayout(), LAYOUT_SEPARATOR);
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    structure = Integer.parseInt(st.nextToken());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return structure;
    }

    public GadgetBean addGadget(final String gadgetName, Map<String, String> gwtParams) throws ClientException {
        String spaceId = this.getParamValue(DOC_REF, gwtParams, true, null);
        CoreSession session = this.getCoreSession(gwtParams);
        if (session != null) {
            try {
                SpaceManager service = (SpaceManager)Framework.getService(SpaceManager.class);
                Gadget g = new Gadget(){

                    public String getCategory() {
                        return null;
                    }

                    public String getDescription() {
                        return null;
                    }

                    public String getId() {
                        return gadgetName;
                    }

                    public String getName() {
                        return gadgetName;
                    }

                    public String getOwner() {
                        return null;
                    }

                    public String getPlaceID() {
                        return null;
                    }

                    public int getPosition() {
                        return 0;
                    }

                    public Map<String, String> getPreferences() {
                        return null;
                    }

                    public String getTitle() {
                        return gadgetName;
                    }

                    public boolean isCollapsed() {
                        return false;
                    }

                    public boolean isEqualTo(Gadget gadget) {
                        return gadget.getId() != null && gadget.getId().equals(this.getId());
                    }
                };
                Gadget createGadget = service.createGadget(g, service.getSpaceFromId(spaceId, session), session);
                return new GadgetMapper(createGadget, session.getPrincipal().getName(), this.shindigId++, PermissionHelper.canWrite(spaceId, session)).getGadgetBean();
            }
            catch (Exception e) {
                throw new ClientException();
            }
        }
        return null;
    }

    public Map<String, ArrayList<String>> getGadgetList() throws ClientException {
        try {
            return ((GadgetService)Framework.getService(GadgetService.class)).getGadgetNameByCategory();
        }
        catch (Exception e) {
            throw new ClientException();
        }
    }

    public Container saveLayout(Map<String, String> containerParams, String layout) throws ClientException {
        CoreSession session = this.getCoreSession(containerParams);
        if (session != null) {
            String spaceId = this.getParamValue(DOC_REF, containerParams, true, null);
            Space space = this.createUpdateSpace(spaceId, session, layout);
            return this.createContainer(space, session);
        }
        return null;
    }

    private Container createContainer(Space space, CoreSession session) {
        try {
            if (space != null) {
                ArrayList<GadgetBean> gadgets = new ArrayList<GadgetBean>();
                Boolean perm = this.getPermission(space, session);
                for (Gadget g : ((SpaceManager)Framework.getService(SpaceManager.class)).getGadgetsForSpace(space, session)) {
                    gadgets.add(new GadgetMapper(g, session.getPrincipal().getName(), this.shindigId++, perm).getGadgetBean());
                }
                Collections.sort(gadgets);
                String layout = space.getLayout();
                if (layout == null || layout.equals("")) {
                    layout = DEFAULT_LAYOUT;
                }
                return new Container(gadgets, this.getStructure(space), layout, perm, space.getId());
            }
        }
        catch (SpaceException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean getPermission(Space space, CoreSession session) {
        if (!space.isVersionnable()) {
            return PermissionHelper.canWrite(space.getId(), session);
        }
        return PermissionHelper.canWrite(space.getId(), session) && !space.isCurrentVersion();
    }

    private Space createUpdateSpace(String spaceId, CoreSession session, final String layout) {
        try {
            final Space space = ((SpaceManager)Framework.getService(SpaceManager.class)).getSpaceFromId(spaceId, session);
            Space spaceUpdate = new Space(){

                public String getCategory() {
                    return space.getCategory();
                }

                public String getDescription() {
                    return space.getDescription();
                }

                public String getId() {
                    return space.getId();
                }

                public String getLayout() {
                    return layout;
                }

                public String getName() {
                    return space.getName();
                }

                public String getOwner() {
                    return space.getOwner();
                }

                public String getTheme() {
                    return space.getTheme();
                }

                public String getTitle() {
                    return space.getTitle();
                }

                public boolean isEqualTo(Space space2) {
                    return space2.isEqualTo(space2);
                }

                public boolean isVersionnable() {
                    return space.isVersionnable();
                }

                public Calendar getDatePublication() {
                    return space.getDatePublication();
                }

                public List<Space> getVersions() {
                    return space.getVersions();
                }

                public boolean isCurrentVersion() {
                    return space.isCurrentVersion();
                }
            };
            return ((SpaceManager)Framework.getService(SpaceManager.class)).updateSpace(spaceUpdate, session);
        }
        catch (SpaceNotFoundException e) {
            log.error((Object)e);
        }
        catch (SpaceException e) {
            log.error((Object)e);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return null;
    }
}

