/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.factory;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.spaces.api.Gadget;
import org.nuxeo.ecm.spaces.api.SpaceManager;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;
import org.nuxeo.opensocial.container.factory.api.GadgetManager;
import org.nuxeo.opensocial.container.factory.mapping.GadgetMapper;
import org.nuxeo.opensocial.container.factory.utils.CoreSessionHelper;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetManagerImpl
implements GadgetManager {
    private static final Log log = LogFactory.getLog(GadgetManagerImpl.class);
    public static final String TITLE_KEY_PREF = "title";

    public void removeGadget(GadgetBean gadget, Map<String, String> gwtParams) throws ClientException {
        try {
            SpaceManager spaceManager = (SpaceManager)Framework.getService(SpaceManager.class);
            CoreSession coreSession = this.getCoreSession(gwtParams);
            spaceManager.deleteGadget((Gadget)new GadgetMapper(gadget), coreSession);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new ClientException((Throwable)e);
        }
    }

    protected CoreSession getCoreSession(Map<String, String> gwtParams) throws Exception {
        return CoreSessionHelper.getCoreSession(gwtParams.get("repoName"));
    }

    public void saveCollapsed(GadgetBean gadget, Map<String, String> gwtParams) {
        this.updateFullGadget(gadget, gwtParams);
    }

    private void updateFullGadget(GadgetBean gadget, Map<String, String> gwtParams) {
        try {
            CoreSession coreSession = this.getCoreSession(gwtParams);
            GadgetMapper gadgetMapper = new GadgetMapper(gadget);
            ((SpaceManager)Framework.getService(SpaceManager.class)).updateGadget((Gadget)gadgetMapper, coreSession);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void savePosition(GadgetBean gadget, Map<String, String> gwtParams) throws ClientException {
        this.updateFullGadget(gadget, gwtParams);
    }

    public void savePreferences(GadgetBean gadget, Map<String, String> updatePrefs, Map<String, String> gwtParams) throws Exception {
        try {
            GadgetMapper gadgetMapper = new GadgetMapper(gadget);
            if (updatePrefs != null) {
                gadgetMapper.setPreferences(updatePrefs);
                if (updatePrefs.containsKey(TITLE_KEY_PREF)) {
                    gadgetMapper.setTitle(updatePrefs.get(TITLE_KEY_PREF));
                }
            }
            gadgetMapper.setName(gadget.getSpaceName());
            ((SpaceManager)Framework.getService(SpaceManager.class)).updateGadget((Gadget)gadgetMapper, this.getCoreSession(gwtParams));
        }
        catch (Exception e) {
            log.error((Object)("GadgetManagerUImlp - savePreferences : " + e.fillInStackTrace()));
        }
    }
}

