/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.factory;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.gadgets.spec.UserPref;
import org.nuxeo.opensocial.container.client.bean.PreferencesBean;
import org.nuxeo.opensocial.container.client.bean.ValuePair;
import org.nuxeo.opensocial.container.factory.DefaultPreference;
import org.nuxeo.opensocial.container.factory.mapping.GadgetMapper;
import org.nuxeo.opensocial.container.factory.utils.GadgetsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceManager {
    static final Log log = LogFactory.getLog(PreferenceManager.class);

    public static ArrayList<PreferencesBean> getDefaultPreferences(GadgetMapper gadget) {
        return PreferenceManager.mergePreferences(DefaultPreference.getPreferences(), gadget.getPreferences());
    }

    public static ArrayList<PreferencesBean> getPreferences(GadgetMapper gadget) {
        return PreferenceManager.mergePreferences(PreferenceManager.getOpenSocialPreferences(gadget), gadget.getPreferences());
    }

    protected static ArrayList<PreferencesBean> mergePreferences(List<UserPref> defaultPrefs, Map<String, String> loadPrefs) {
        ArrayList<PreferencesBean> prefs = new ArrayList<PreferencesBean>();
        if (loadPrefs != null) {
            for (UserPref pref : defaultPrefs) {
                prefs.add(PreferenceManager.setLoadValue(loadPrefs, PreferenceManager.buildPrefBean(pref)));
            }
        }
        return prefs;
    }

    private static PreferencesBean buildPrefBean(UserPref p) {
        return new PreferencesBean(p.getDataType().toString(), p.getDefaultValue(), p.getDisplayName(), PreferenceManager.getSerializableEnumValues(p.getOrderedEnumValues()), p.getName(), null);
    }

    protected static PreferencesBean setLoadValue(Map<String, String> prefs, PreferencesBean p) {
        for (String name : prefs.keySet()) {
            if (!name.equals(p.getName())) continue;
            p.setValue(prefs.get(name));
            break;
        }
        return p;
    }

    protected static List<UserPref> getOpenSocialPreferences(GadgetMapper gadget) {
        try {
            return GadgetsUtils.getGadgetSpec(gadget).getUserPrefs();
        }
        catch (Exception e) {
            log.error((Object)e);
            return new ArrayList<UserPref>();
        }
    }

    private static List<ValuePair> getSerializableEnumValues(List<UserPref.EnumValuePair> orderedEnumValues) {
        LinkedList<ValuePair> values = new LinkedList<ValuePair>();
        for (UserPref.EnumValuePair vPair : orderedEnumValues) {
            values.add(new ValuePair(vPair.getValue(), vPair.getDisplayValue()));
        }
        return values;
    }
}

