/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.factory.mapping;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.gadgets.spec.View;
import org.nuxeo.ecm.spaces.api.Gadget;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;
import org.nuxeo.opensocial.container.client.bean.GadgetPosition;
import org.nuxeo.opensocial.container.client.bean.GadgetView;
import org.nuxeo.opensocial.container.client.bean.PreferencesBean;
import org.nuxeo.opensocial.container.factory.PreferenceManager;
import org.nuxeo.opensocial.container.factory.utils.GadgetsUtils;
import org.nuxeo.opensocial.container.factory.utils.UrlBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetMapper
extends GadgetBean
implements Gadget {
    private Map<String, String> preferences = new HashMap<String, String>();
    private static final Log log = LogFactory.getLog(GadgetMapper.class);
    private static final String BOOL = "BOOL";
    private Integer pos;
    private String placeID;
    private String owner;
    private GadgetBean bean;
    private String title;
    private Boolean collapsed;
    private String ref;
    private GadgetPosition position;
    private List<PreferencesBean> defaultPrefs;
    private List<PreferencesBean> userPrefs;
    private String renderUrl;
    private String viewer;
    private Integer shindigId;
    private boolean permission;
    private String name;
    private String spaceName;

    public GadgetMapper(GadgetBean bean) {
        this.bean = bean;
        this.title = bean.getTitle();
        this.collapsed = bean.isCollapse();
        this.ref = bean.getRef();
        this.position = bean.getGadgetPosition();
        if (this.position != null) {
            this.placeID = this.position.getPlaceID();
            this.pos = this.position.getPosition();
        }
        this.preferences = this.createPreferences(bean);
        this.defaultPrefs = bean.getDefaultPrefs();
        this.userPrefs = bean.getUserPrefs();
        this.viewer = bean.getViewer();
        this.shindigId = bean.getShindigId();
        this.permission = bean.getPermission();
        this.name = bean.getName();
        this.spaceName = bean.getSpaceName();
        this.renderUrl = this.updateRenderUrl();
    }

    private String updateRenderUrl() {
        String url = this.createRenderUrl();
        this.bean.setRenderUrl(url);
        return url;
    }

    public GadgetMapper(Gadget gadget, String viewer, int shindigId, boolean permission) {
        this.title = gadget.getTitle();
        this.spaceName = gadget.getName();
        this.name = this.getRealName(gadget.getName());
        this.collapsed = gadget.isCollapsed();
        this.ref = gadget.getId();
        this.placeID = gadget.getPlaceID();
        this.pos = gadget.getPosition();
        this.position = new GadgetPosition(this.placeID, this.pos.intValue());
        this.preferences = gadget.getPreferences();
        this.owner = gadget.getOwner();
        this.viewer = viewer;
        this.shindigId = shindigId;
        this.permission = permission;
        this.createGadgetBean();
    }

    public Boolean getPermission() {
        return true;
    }

    public String getRenderUrl() {
        return this.renderUrl;
    }

    public Integer getShindigId() {
        return this.shindigId;
    }

    public String getTitle() {
        return this.title;
    }

    public List<PreferencesBean> getUserPrefs() {
        return this.userPrefs;
    }

    public String getViewer() {
        return this.viewer;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getCategory() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String getId() {
        return this.ref;
    }

    public String getName() {
        return this.name;
    }

    public String getPlaceID() {
        return this.placeID;
    }

    public int getPosition() {
        return this.pos;
    }

    public Map<String, String> getPreferences() {
        return this.preferences;
    }

    public String getType() {
        return null;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    private String getRealName(String name) {
        StringTokenizer st = new StringTokenizer(name, ".");
        return st.nextToken();
    }

    public void setPreferences(Map<String, String> updatePrefs) throws Exception {
        this.preferences = updatePrefs;
        for (PreferencesBean p : this.userPrefs) {
            this.updatePrefValue(updatePrefs, p);
        }
        for (PreferencesBean p : this.defaultPrefs) {
            this.updatePrefValue(updatePrefs, p);
        }
        this.bean.setRenderUrl(UrlBuilder.buildShindigUrl(this));
        this.bean.setUserPrefs(this.userPrefs);
    }

    private void updatePrefValue(Map<String, String> updatePrefs, PreferencesBean p) throws UnsupportedEncodingException {
        if (updatePrefs.containsKey(p.getName())) {
            String val = URLDecoder.decode(updatePrefs.get(p.getName()), "UTF-8");
            if (p.getDataType().equals(BOOL)) {
                val = "true";
            } else if (p.getDataType().equals(BOOL)) {
                val = "false";
            }
            p.setValue(val);
        }
    }

    private String createRenderUrl() {
        try {
            return UrlBuilder.buildShindigUrl(this);
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    private Map<String, String> createPreferences(GadgetBean b) {
        HashMap<String, String> prefs = new HashMap<String, String>();
        return this.buildPreferences(this.buildPreferences(prefs, b.getUserPrefs()), b.getDefaultPrefs());
    }

    private Map<String, String> buildPreferences(Map<String, String> prefs, List<PreferencesBean> uPrefs) {
        if (uPrefs != null) {
            for (PreferencesBean p : uPrefs) {
                prefs.put(p.getName(), p.getValue());
            }
        }
        return prefs;
    }

    public void createGadgetBean() {
        this.userPrefs = PreferenceManager.getPreferences(this);
        this.defaultPrefs = PreferenceManager.getDefaultPreferences(this);
        this.updateTitleInPreference();
        this.bean = new GadgetBean(this.shindigId, this.ref, this.title, this.viewer, this.defaultPrefs, this.userPrefs, Boolean.valueOf(this.permission), this.collapsed, this.name, this.spaceName, this.createGadgetViews());
        this.renderUrl = this.updateRenderUrl();
        this.bean.setRenderUrl(this.renderUrl);
        this.bean.setPosition(this.position);
    }

    private Map<String, GadgetView> createGadgetViews() {
        HashMap<String, GadgetView> gv = new HashMap<String, GadgetView>();
        try {
            Map views = GadgetsUtils.getGadgetSpec(this).getViews();
            for (String v : views.keySet()) {
                View view = (View)views.get(v);
                gv.put(v, new GadgetView(view.getName(), view.getType().toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return gv;
    }

    private void updateTitleInPreference() {
        for (PreferencesBean p : this.userPrefs) {
            if (!"title".equals(p.getName()) || p.getValue() == null) continue;
            this.title = p.getValue();
            return;
        }
    }

    public GadgetBean getGadgetBean() {
        return this.bean;
    }

    public boolean isEqualTo(Gadget gadget) {
        return gadget.getId() != null && gadget.getId().equals(this.getId());
    }

    public void setTitle(String title) {
        super.setTitle(title);
        this.bean.setTitle(title);
    }

    public void setName(String name) {
        this.name = this.spaceName;
    }
}

