/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.factory.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;

public class PermissionHelper {
    private static final Log log = LogFactory.getLog(PermissionHelper.class);
    public static final String PERMISSION_WRITE = "WRITE";

    public static boolean canWrite(String docId, CoreSession session) {
        try {
            DocumentModel doc = session.getDocument((DocumentRef)new IdRef(docId));
            boolean hasPermission = session.hasPermission(doc.getRef(), PERMISSION_WRITE);
            return hasPermission;
        }
        catch (ClientException e) {
            log.error((Object)e);
            return false;
        }
    }
}

