/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.factory;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.gadgets.spec.View;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.spaces.api.Gadget;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;
import org.nuxeo.opensocial.container.client.bean.GadgetPosition;
import org.nuxeo.opensocial.container.client.bean.GadgetView;
import org.nuxeo.opensocial.container.factory.GadgetAdapter;
import org.nuxeo.opensocial.container.factory.PreferenceManager;
import org.nuxeo.opensocial.container.factory.utils.GadgetsUtils;
import org.nuxeo.opensocial.container.factory.utils.UrlBuilder;

public class GadgetFactory {
    private static final Log log = LogFactory.getLog(GadgetFactory.class);

    public static GadgetBean getGadgetBean(Gadget gadget, String locale, String serverBase) throws ClientException {
        GadgetBean bean = new GadgetBean();
        bean.setCollapsed(gadget.isCollapsed());
        bean.setHeight(Integer.valueOf(gadget.getHeight()));
        bean.setPosition(new GadgetPosition(gadget.getPlaceId(), gadget.getPosition()));
        bean.setRenderUrl(UrlBuilder.buildShindigUrl(gadget, serverBase, locale));
        bean.setTitle(GadgetFactory.getTitle(gadget));
        bean.setUserPrefs(PreferenceManager.getPreferences(gadget));
        bean.setDefaultPrefs(PreferenceManager.getDefaultPreferences(gadget));
        bean.setGadgetViews(GadgetFactory.createGadgetViews(gadget));
        bean.setName(gadget.getName());
        bean.setRef(gadget.getId());
        bean.setViewer(gadget.getViewer());
        bean.setEditable(gadget.isEditable());
        bean.setConfigurable(gadget.isConfigurable());
        return bean;
    }

    private static String getTitle(Gadget gadget) throws ClientException {
        if (gadget.getTitle() != null && !gadget.getTitle().equals("")) {
            return GadgetFactory._getTitleWithoutKey(gadget.getTitle());
        }
        return "";
    }

    private static String _getTitleWithoutKey(String title) {
        StringTokenizer st = new StringTokenizer(title, ".");
        return st.nextToken();
    }

    private static Map<String, GadgetView> createGadgetViews(Gadget gadget) {
        HashMap<String, GadgetView> gv = new HashMap<String, GadgetView>();
        try {
            Map views = GadgetsUtils.getGadgetSpec(gadget).getViews();
            for (String v : views.keySet()) {
                View view = (View)views.get(v);
                gv.put(v, new GadgetView(view.getName(), view.getType().toString()));
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return gv;
    }

    public static Gadget getGadget(GadgetBean bean) throws ClientException {
        return GadgetFactory.getGadget(bean, null);
    }

    public static Gadget getGadget(GadgetBean bean, Map<String, String> updatePrefs) throws ClientException {
        return new GadgetAdapter(bean, updatePrefs);
    }
}

