/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.server.rest;

import com.google.gson.Gson;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.opensocial.container.server.rest.FoldersListGson;

@WebObject(type="folderWebObject")
public class FolderWebObject
extends DocumentObject {
    private static final Log log = LogFactory.getLog(FolderWebObject.class);

    @GET
    @Produces(value={"text/json"})
    @Path(value="gadgetChildren")
    public Object doGetGadgetChildrenInParentWs(@QueryParam(value="type") String type) throws ClientException {
        String logPrefix = "<doGetGadgetChildrenInParentWs>";
        CoreSession session = this.ctx.getCoreSession();
        DocumentModel parentWorkspace = this.getParentWorkspace(this.doc);
        log.debug((Object)("<doGetGadgetChildrenInParentWs>" + this.doc));
        DocumentModelList list = session.getChildren(parentWorkspace.getRef(), type);
        Gson gson = new Gson();
        String response = gson.toJson((Object)new FoldersListGson((Collection<DocumentModel>)list, session));
        return response;
    }

    private DocumentModel getParentWorkspace(DocumentModel doc) throws ClientException {
        DocumentModel parentDocument = this.ctx.getCoreSession().getParentDocument(doc.getRef());
        if ("Workspace".equals(parentDocument.getType())) {
            return parentDocument;
        }
        return this.getParentWorkspace(parentDocument);
    }
}

