/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.client.view;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.core.ExtElement;
import com.gwtext.client.dd.DragData;
import com.gwtext.client.dd.DragSource;
import com.gwtext.client.dd.DropTargetConfig;
import com.gwtext.client.dd.ScrollManager;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Container;
import com.gwtext.client.widgets.event.PanelListener;
import com.gwtext.client.widgets.portal.PanelProxy;
import com.gwtext.client.widgets.portal.Portal;
import com.gwtext.client.widgets.portal.PortalColumn;
import com.gwtext.client.widgets.portal.PortalDropZone;
import java.util.ArrayList;
import org.nuxeo.opensocial.container.client.ContainerEntryPoint;
import org.nuxeo.opensocial.container.client.JsLibrary;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;
import org.nuxeo.opensocial.container.client.bean.GadgetPosition;
import org.nuxeo.opensocial.container.client.view.ComplexPosGrid;
import org.nuxeo.opensocial.container.client.view.ContainerPortal;
import org.nuxeo.opensocial.container.client.view.DefaultPosGrid;
import org.nuxeo.opensocial.container.client.view.GadgetPortlet;
import org.nuxeo.opensocial.container.client.view.PortletListener;
import org.nuxeo.opensocial.container.client.view.PosGrid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropZone
extends PortalDropZone {
    private static final String DEFAULT = "default";
    private static final String ZONE_CLASS = "x-column-possible";
    private static final int GHOST_HEIGHT = 100;
    private static final int GHOST_WIDTH = 140;
    private static ContainerPortal portal;
    private int lastCW = -1;
    private PosGrid[] grid;
    private Container lastPosC;
    private int col;
    Timer t;

    public DropZone(ContainerPortal portal, DropTargetConfig config) {
        super((Portal)portal, config);
        ScrollManager.register((com.google.gwt.user.client.Element)portal.getBody().getDOM());
        DropZone.portal = portal;
        DropZone.overrideDragDrop(140, 100, ZONE_CLASS);
    }

    private static native void overrideDragDrop(int var0, int var1, String var2);

    public static void endDragDrop(String id) {
        GadgetPortlet gp = portal.getGadgetPortlet(id);
        if (gp.getGadgetBean().isCollapsed()) {
            GadgetPortlet.collapse(id, "");
            gp.addListener((PanelListener)new PortletListener(gp));
        }
        JsLibrary.hideGwtContainerMask();
        gp.setAutoWidth(true);
    }

    public String notifyOver(DragSource source, final EventObject e, DragData data) {
        if (this.t != null) {
            this.t.cancel();
        }
        final JavaScriptObject jsObj = source.getProxy().getJsObj();
        this.t = new Timer(){

            public void run() {
                DropZone.this._notifyEnter(new PanelProxy(jsObj), e);
            }
        };
        this.t.schedule(60);
        return "x-dd-drop-ok";
    }

    private void _notifyEnter(PanelProxy proxy, EventObject e) {
        int[] xy = e.getXY();
        if (this.grid == null) {
            this.grid = this.getGrid();
        }
        int cw = portal.getBody().getClientWidth();
        if (this.lastCW == -1) {
            this.lastCW = cw;
        } else if (this.lastCW != cw) {
            this.lastCW = cw;
            portal.doLayout();
            this.grid = this.getGrid();
        }
        this.col = 0;
        boolean cmatch = false;
        int len = this.grid.length;
        while (this.col < len) {
            PosGrid posGrid = this.grid[this.col];
            if (posGrid.isCol(xy)) {
                cmatch = true;
                break;
            }
            ++this.col;
        }
        if (!cmatch) {
            --this.col;
        }
        boolean match = false;
        int pos = 0;
        this.lastPosC = (Container)portal.getItems()[this.col];
        Component[] items = this.lastPosC.getItems();
        Component p = null;
        for (pos = 0; pos < items.length; ++pos) {
            p = items[pos];
            int height = p.getEl().getHeight();
            if (height == 0 || p.getEl().getY() + height / 2 <= xy[1]) continue;
            match = true;
            break;
        }
        proxy.getProxy().setWidth("auto", false);
        if (p != null) {
            proxy.moveProxy(p.getEl().getParentNode(), match ? p.getEl().getDOM() : null);
        } else {
            proxy.moveProxy(this.lastPosC.getEl().getDOM(), null);
        }
    }

    public String notifyEnter(DragSource source, EventObject e, DragData data) {
        JsLibrary.showGwtContainerMask();
        return super.notifyEnter(source, e, data);
    }

    public void notifyOut(DragSource source, EventObject e, DragData data) {
        this.grid = null;
        JsLibrary.hideGwtContainerMask();
        this.notifyEnter(source, e, data);
    }

    public boolean notifyDrop(DragSource source, EventObject e, DragData data) {
        GadgetPortlet gp = portal.getGadgetPortlet(source.getId());
        GadgetPosition dropPosition = portal.getDropPosition(source.getId());
        if (dropPosition != null) {
            this.saveDropZone(gp, dropPosition);
        }
        this.grid = null;
        PanelProxy proxy = new PanelProxy(source.getProxy().getJsObj());
        proxy.getProxy().remove();
        if (!ContainerEntryPoint.waitForGadgetsValidation() && this.lastPosC != null) {
            if (dropPosition != null) {
                this.lastPosC.remove(gp.getId());
                this.lastPosC.insert(dropPosition.getPosition().intValue(), (Component)gp);
            }
            this.lastPosC.doLayout();
            this.lastPosC = null;
        }
        gp.renderDefaultPreferences();
        gp.setAutoWidth(true);
        return true;
    }

    private PosGrid[] getGrid() {
        Component[] items = portal.getItems();
        if (portal.getContainer().getLayout().contains(DEFAULT)) {
            return this.getDefaultGrid(items);
        }
        return this.getComplexGrid(items);
    }

    private PosGrid[] getDefaultGrid(Component[] items) {
        PosGrid[] posGrid = new PosGrid[items.length];
        for (int i = 0; i < items.length; ++i) {
            ExtElement elem = items[i].getEl();
            posGrid[i] = new DefaultPosGrid(elem.getX(), elem.getWidth());
        }
        return posGrid;
    }

    private PosGrid[] getComplexGrid(Component[] items) {
        PosGrid[] posGrid = new PosGrid[items.length];
        for (int i = 0; i < items.length; ++i) {
            ExtElement elem = items[i].getEl();
            posGrid[i] = new ComplexPosGrid(elem.getX(), elem.getWidth(), elem.getY(), elem.getHeight());
        }
        return posGrid;
    }

    private void saveDropZone(final GadgetPortlet gp, final GadgetPosition dropPosition) {
        GadgetBean bean = gp.getGadgetBean();
        final GadgetPosition prevPosition = bean.getGadgetPosition();
        PortalColumn dragCol = portal.getPortalColumn(bean.getGadgetPosition().getPlaceID());
        PortalColumn dropCol = portal.getPortalColumn(dropPosition.getPlaceID());
        bean.setPosition(dropPosition);
        ArrayList<GadgetBean> beans = DropZone.getOrderingAndUpdatingBeans(dragCol, bean);
        beans.addAll(DropZone.getOrderingAndUpdatingBeans(dropCol, bean));
        ContainerEntryPoint.getService().saveGadgetsCollection(beans, ContainerEntryPoint.getGwtParams(), new AsyncCallback<Boolean>(){

            public void onFailure(Throwable arg0) {
                gp.getGadgetBean().setPosition(prevPosition);
            }

            public void onSuccess(Boolean success) {
                if (ContainerEntryPoint.waitForGadgetsValidation()) {
                    if (success.booleanValue()) {
                        if (DropZone.this.lastPosC != null) {
                            if (dropPosition != null) {
                                DropZone.this.lastPosC.remove(gp.getId());
                                DropZone.this.lastPosC.insert(dropPosition.getPosition().intValue(), (Component)gp);
                            }
                            DropZone.this.lastPosC.doLayout();
                            DropZone.this.lastPosC = null;
                        }
                    } else {
                        gp.getGadgetBean().setPosition(prevPosition);
                    }
                }
            }
        });
    }

    private static ArrayList<GadgetBean> getOrderingAndUpdatingBeans(PortalColumn col, GadgetBean bean) {
        ArrayList<GadgetBean> gadgets = new ArrayList<GadgetBean>();
        NodeList childs = col.getElement().getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            GadgetPortlet p = portal.getGadgetPortlet(Element.as((Node)childs.getItem(i)).getId());
            if (p == null) continue;
            GadgetBean b = p.getGadgetBean();
            if (!bean.getRef().equals(b.getRef())) {
                b.getGadgetPosition().setPosition(i);
            }
            gadgets.add(b);
        }
        return gadgets;
    }
}

