/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.service;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.opensocial.container.client.bean.Container;
import org.nuxeo.opensocial.container.client.bean.ContainerServiceException;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;
import org.nuxeo.opensocial.container.client.bean.PreferencesBean;
import org.nuxeo.opensocial.container.client.service.api.ContainerService;
import org.nuxeo.opensocial.container.component.api.FactoryManager;
import org.nuxeo.opensocial.container.factory.api.GadgetManager;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerServiceImpl
extends RemoteServiceServlet
implements ContainerService {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ContainerServiceImpl.class);

    @Override
    public Container getContainer(Map<String, String> gwtParams) throws ContainerServiceException {
        try {
            return ((FactoryManager)Framework.getService(FactoryManager.class)).getContainerFactory().createContainer(gwtParams);
        }
        catch (Exception e) {
            log.error((Object)("Get container error " + e), (Throwable)e);
            throw new ContainerServiceException(e.getMessage(), e);
        }
    }

    @Override
    public GadgetBean saveGadgetPreferences(GadgetBean gadget, String form, Map<String, String> gwtParams) throws ContainerServiceException {
        try {
            Map<Object, Object> updatePrefs = new HashMap();
            if (form != null && (updatePrefs = this.getParameters(form)).containsKey("title")) {
                gadget.setTitle((String)updatePrefs.get("title"));
            }
            List<PreferencesBean> userPrefs = gadget.getUserPrefs();
            for (PreferencesBean bean : userPrefs) {
                if (updatePrefs.containsKey(bean.getName()) || !bean.getDataType().equals("BOOL")) continue;
                updatePrefs.put(bean.getName(), "false");
            }
            return ((FactoryManager)Framework.getService(FactoryManager.class)).getGadgetFactory().savePreferences(gadget, updatePrefs, gwtParams);
        }
        catch (Exception e) {
            log.error((Object)("saveGadgetPreferences " + e), (Throwable)e);
            throw new ContainerServiceException(e.getMessage(), e);
        }
    }

    @Override
    public Boolean saveGadgetsCollection(Collection<GadgetBean> beans, Map<String, String> gwtParams) throws ContainerServiceException {
        try {
            GadgetManager factory = ((FactoryManager)Framework.getService(FactoryManager.class)).getGadgetFactory();
            if (!factory.validateGadgets(beans, gwtParams).booleanValue()) {
                return false;
            }
            for (GadgetBean gadget : beans) {
                factory.saveGadget(gadget, gwtParams);
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new ContainerServiceException(e.getMessage(), e);
        }
        return true;
    }

    @Override
    public GadgetBean removeGadget(GadgetBean gadget, Map<String, String> gwtParams) throws ContainerServiceException {
        try {
            ((FactoryManager)Framework.getService(FactoryManager.class)).getGadgetFactory().removeGadget(gadget, gwtParams);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new ContainerServiceException(e.getMessage(), e);
        }
        return gadget;
    }

    @Override
    public Map<String, ArrayList<String>> getGadgetList(Map<String, String> gwtParams) throws ContainerServiceException {
        try {
            return ((FactoryManager)Framework.getService(FactoryManager.class)).getContainerFactory().getGadgetList();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ContainerServiceException(e.getMessage(), e);
        }
    }

    @Override
    public GadgetBean addGadget(String gadgetName, Map<String, String> gwtParams) throws ContainerServiceException {
        try {
            return ((FactoryManager)Framework.getService(FactoryManager.class)).getContainerFactory().addGadget(gadgetName, gwtParams);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ContainerServiceException(e.getMessage(), e);
        }
    }

    public static String decode(String string) {
        try {
            string = new URI('?' + string).getQuery();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private Map<String, String> getParameters(String form) {
        StringTokenizer params = new StringTokenizer(form, "&");
        HashMap<String, String> map = new HashMap<String, String>();
        while (params.hasMoreTokens()) {
            StringTokenizer st = new StringTokenizer(params.nextToken(), "=");
            String key = "";
            String value = "";
            if (st.hasMoreTokens()) {
                key = ContainerServiceImpl.decode(st.nextToken());
            }
            while (st.hasMoreTokens()) {
                value = value + ContainerServiceImpl.decode(st.nextToken());
            }
            if (value.equals("on")) {
                value = "true";
            }
            map.put(key, value);
        }
        return map;
    }

    @Override
    public Container saveLayout(Map<String, String> gwtParams, String layout) throws ContainerServiceException {
        try {
            return ((FactoryManager)Framework.getService(FactoryManager.class)).getContainerFactory().saveLayout(gwtParams, layout);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ContainerServiceException(e.getMessage(), e);
        }
    }

    @Override
    public GadgetBean saveGadget(GadgetBean gadget, Map<String, String> gwtParams) throws ContainerServiceException {
        try {
            return ((FactoryManager)Framework.getService(FactoryManager.class)).getGadgetFactory().saveGadget(gadget, gwtParams);
        }
        catch (ClientException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new ContainerServiceException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return gadget;
        }
    }
}

