/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.client.view;

import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.event.PanelListener;
import com.gwtext.client.widgets.layout.ContainerLayout;
import com.gwtext.client.widgets.layout.FitLayout;
import com.gwtext.client.widgets.portal.Portlet;
import org.nuxeo.opensocial.container.client.GadgetService;
import org.nuxeo.opensocial.container.client.JsLibrary;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;
import org.nuxeo.opensocial.container.client.bean.GadgetView;
import org.nuxeo.opensocial.container.client.bean.PreferencesBean;
import org.nuxeo.opensocial.container.client.view.GadgetForm;
import org.nuxeo.opensocial.container.client.view.GadgetTools;
import org.nuxeo.opensocial.container.client.view.PortletListener;

public class GadgetPortlet
extends Portlet {
    private static final String NONE_PROPERTY = "none";
    private static final String PREFIX_PORTLET_ID = "portlet-";
    static final String PREFIX_FRAME_ID = "gadget-";
    public static final String CANVAS_VIEW = "canvas";
    public static final String DEFAULT_VIEW = "default";
    private GadgetBean gadget;
    private GadgetTools tools;
    private Frame frame;
    private GadgetForm form;
    private String view;

    public GadgetPortlet(GadgetBean gadget, String view) {
        this.gadget = gadget;
        this.view = view;
        this.buildPortlet();
        this.form = new GadgetForm(this);
        this.tools.setGadgetForm(this.form);
        this.setVisible(false);
    }

    public GadgetPortlet(GadgetBean bean) {
        this(bean, DEFAULT_VIEW);
    }

    private void buildPortlet() {
        this.setLayout((ContainerLayout)new FitLayout());
        this.setTitle(this.gadget.getTitle());
        if (!this.view.equals(DEFAULT_VIEW)) {
            this.setDraggable(false);
            this.setHideCollapseTool(true);
        } else {
            this.setDraggable(this.gadget.isEditable());
            if (!this.gadget.isConfigurable()) {
                this.setHideCollapseTool(true);
            }
        }
        this.setHeight(this.gadget.getHeight());
        this.addListener((PanelListener)new PortletListener(this));
        this.frame = this.buildFrame();
        this.add((Widget)this.frame);
        this.setId(GadgetPortlet.getIdWithRefAndView(this.gadget.getRef(), this.view));
        this.tools = new GadgetTools(this);
        this.setTools(this.tools.getButtons());
        GadgetService.setAuthToken(this.getIframeId(), this.gadget.getRef());
        GadgetService.setRelayRpc(this.getIframeId(), this.gadget.getRef());
    }

    void renderDefaultPreferences() {
        for (PreferencesBean p : this.gadget.getDefaultPrefs()) {
            this.renderPreference(p.getName(), p.getValue() != null ? p.getValue() : p.getDefaultValue());
        }
    }

    public void renderPreference(String name, String value) {
        if (DEFAULT_PREFS.isBorder(name)) {
            if (!NONE_PROPERTY.equals(value)) {
                GadgetPortlet.changeBorderColor(this.getId(), value);
            } else {
                GadgetPortlet.removeBorderColor(this.getId());
            }
        } else if (DEFAULT_PREFS.isFont(name)) {
            if (!NONE_PROPERTY.equals(value)) {
                GadgetPortlet.changeTitleColor(this.getId(), value);
            } else {
                GadgetPortlet.removeTitleColor(this.getId());
            }
        } else if (DEFAULT_PREFS.isHeader(name)) {
            if (NONE_PROPERTY.equals(value)) {
                GadgetPortlet.removeHeaderColor(this.getId());
            } else {
                GadgetPortlet.changeHeaderColor(this.getId(), value);
            }
        }
    }

    static String getIdWithRefAndView(String ref, String view) {
        if (view == null) {
            view = DEFAULT_VIEW;
        }
        return PREFIX_PORTLET_ID + view + "-" + ref;
    }

    static String getIdWithIframeId(String iframeId) {
        return iframeId.replace(PREFIX_FRAME_ID, PREFIX_PORTLET_ID);
    }

    private Frame buildFrame() {
        this.reloadRenderUrl();
        Frame f = new Frame(this.gadget.getRenderUrl());
        f.setHeight("100%");
        f.setWidth("100%");
        Element elem = f.getElement();
        elem.setId(this.getIframeId());
        elem.setAttribute("name", this.getIframeId());
        elem.setAttribute("overflow", "hidden");
        return f;
    }

    public void setTitle(String title) {
        if (title != null) {
            super.setTitle(title);
            this.gadget.setTitle(title);
            if (this.form != null) {
                this.form.setTitle(title);
            }
            if (this.tools != null) {
                this.tools.setTitle(title);
            }
        }
    }

    public void setPortletTitle(String title) {
        if (title != null) {
            super.setTitle(title);
            if (this.form != null) {
                this.form.setTitle(title);
            }
        }
    }

    public void reloadRenderUrl() {
        String url = this.gadget.getRenderUrl();
        if (url == null) {
            return;
        }
        this.gadget.setRenderUrl(GadgetPortlet.buildUrl(url, this.view));
    }

    private static native String buildUrl(String var0, String var1);

    String getIframeId() {
        return PREFIX_FRAME_ID + this.view + "-" + this.gadget.getRef();
    }

    public void doLayoutFrame() {
        JsLibrary.updateIframe(this.getIframeId(), this.gadget.getRenderUrl());
    }

    public void updateGadgetPortlet() {
        this.reloadRenderUrl();
        this.setGadgetBean(this.gadget);
        this.frame = this.buildFrame();
    }

    void setGadgetBean(GadgetBean bean) {
        this.gadget = bean;
        this.form.setGadget(bean);
    }

    public GadgetBean getGadgetBean() {
        return this.gadget;
    }

    protected void afterRender() {
        if (this.gadget.isCollapsed()) {
            GadgetPortlet.collapse(GadgetPortlet.getIdWithRefAndView(this.gadget.getRef(), this.view), "x-tmp-collapsed");
        }
        super.afterRender();
        this.updateFrameHeightIfContentTypeIsUrl();
        Timer t = new Timer(){

            public void run() {
                GadgetPortlet.this.renderDefaultPreferences();
            }
        };
        t.schedule(200);
    }

    private void updateFrameHeightIfContentTypeIsUrl() {
        GadgetView v = this.gadget.getView(this.view);
        if (v != null && "URL".equals(v.getContentType().toUpperCase())) {
            this.setHeight(600);
        }
    }

    static native void collapse(String var0, String var1);

    static native void unCollapse(String var0, String var1, String var2);

    public GadgetTools getTools() {
        return this.tools;
    }

    public void unCollapseGadget() {
        GadgetPortlet.unCollapse(this.getId(), this.getIframeId(), this.gadget.getRenderUrl());
        this.gadget.setCollapsed(false);
    }

    public void collapseGadget() {
        GadgetPortlet.collapse(this.getId(), "");
        this.gadget.setCollapsed(true);
    }

    public String getView() {
        return this.view;
    }

    public GadgetForm getGadgetForm() {
        return this.form;
    }

    public void setView(String view) {
        this.view = view;
    }

    private static native void removeHeaderColor(String var0);

    private static native void changeHeaderColor(String var0, String var1);

    static native void changeBorderColor(String var0, String var1);

    static native void removeBorderColor(String var0);

    static native void removeBorder(String var0);

    static native void changeTitleColor(String var0, String var1);

    static native void removeTitleColor(String var0);

    public void renderTitle() {
        this.setTitle(this.gadget.getTitle());
    }

    public void removeStyle() {
        GadgetPortlet._removeStyle(this.id);
    }

    private static native void _removeStyle(String var0);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DEFAULT_PREFS {
        COLOR_header,
        COLOR_font,
        COLOR_border;


        public static boolean isHeader(String name) {
            return COLOR_header.name().equals(name);
        }

        public static boolean isFont(String name) {
            return COLOR_font.name().equals(name);
        }

        public static boolean isBorder(String name) {
            return COLOR_border.name().equals(name);
        }
    }
}

