/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.layout.ContainerLayout;
import com.gwtext.client.widgets.layout.FitLayout;
import java.util.HashMap;
import org.nuxeo.opensocial.container.client.ContainerConstants;
import org.nuxeo.opensocial.container.client.GadgetService;
import org.nuxeo.opensocial.container.client.JsLibrary;
import org.nuxeo.opensocial.container.client.bean.Container;
import org.nuxeo.opensocial.container.client.service.api.ContainerService;
import org.nuxeo.opensocial.container.client.service.api.ContainerServiceAsync;
import org.nuxeo.opensocial.container.client.view.AddGadgetAsyncCallback;
import org.nuxeo.opensocial.container.client.view.ContainerPortal;

public class ContainerEntryPoint
implements EntryPoint {
    private static final String SERVICE_ENTRY_POINT = ContainerEntryPoint.getContextPath() + "/gwtcontainer";
    private static final String GWT_WINDOW_WIDTH = "windowWidth";
    public static final int PANEL_WIDTH = 970;
    private static final int MARGIN_FROM_FULL_WIDTH = 70;
    private static final String GWT_CONTAINER_ID = "gwtContainer";
    private static final String CONTAINER_PANEL_ID = "containerPanel";
    private static final ContainerServiceAsync SERVICE = (ContainerServiceAsync)GWT.create(ContainerService.class);
    private static final ContainerConstants CONSTANTS = (ContainerConstants)GWT.create(ContainerConstants.class);
    private static final HashMap<String, String> GWT_PARAMS = new HashMap();
    ServiceDefTarget endpoint = (ServiceDefTarget)SERVICE;
    private static ContainerPortal portal;
    private int windowWidth = 970;

    public void onModuleLoad() {
        JsLibrary.loadingShow();
        this.endpoint.setServiceEntryPoint(SERVICE_ENTRY_POINT);
        JSONObject objects = JSONParser.parse((String)ContainerEntryPoint.getInitialisationParams()).isObject();
        for (String key : objects.keySet()) {
            GWT_PARAMS.put(key, ContainerEntryPoint.getGwtParam(objects, key));
        }
        if (!GWT_PARAMS.containsKey("locale")) {
            GWT_PARAMS.put("locale", LocaleInfo.getCurrentLocale().getLocaleName());
        }
        this.windowWidth = this.getWindowWidth(objects);
        SERVICE.getContainer(GWT_PARAMS, new AsyncCallback<Container>(){

            public void onFailure(Throwable object) {
                ContainerPortal.showErrorMessage(CONSTANTS.error(), CONSTANTS.loadingError());
                JsLibrary.loadingHide();
            }

            public void onSuccess(final Container container) {
                GadgetService.registerService();
                Panel panel = new Panel();
                panel.setBorder(false);
                panel.setId(ContainerEntryPoint.CONTAINER_PANEL_ID);
                panel.setLayout((ContainerLayout)new FitLayout());
                RootPanel.get((String)ContainerEntryPoint.GWT_CONTAINER_ID).add((Widget)panel);
                portal = new ContainerPortal(container, panel);
                panel.setWidth(ContainerEntryPoint.this.windowWidth);
                panel.setHeight("100%");
                JsLibrary.updateFrameWidth();
                JsLibrary.updateColumnStyle();
                ContainerEntryPoint.createGwtContainerMask();
                Timer t = new Timer(){

                    public void run() {
                        portal.showPortlets();
                        ContainerEntryPoint.attachLayoutManager(container.getLayout(), container.getStructure());
                        JsLibrary.loadingHide();
                    }
                };
                t.schedule(200);
            }
        });
    }

    private int getWindowWidth(JSONObject objects) {
        JSONNumber width;
        JSONValue value = objects.get(GWT_WINDOW_WIDTH);
        if (value != null && (width = value.isNumber()) != null) {
            this.windowWidth = (int)width.doubleValue();
            this.windowWidth -= 70;
        }
        return this.windowWidth;
    }

    private static String getGwtParam(JSONObject object, String key) {
        String value = object.get(key).toString();
        return value.substring(1, value.length() - 1);
    }

    public static ContainerServiceAsync getService() {
        return SERVICE;
    }

    public static ContainerPortal getContainerPortal() {
        return portal;
    }

    public static HashMap<String, String> getGwtParams() {
        return GWT_PARAMS;
    }

    static void chooseLayout(String name) {
        ContainerEntryPoint.getService().saveLayout(ContainerEntryPoint.getGwtParams(), name, new AsyncCallback<Container>(){
            Container container = ContainerEntryPoint.access$100().getContainer();
            final String oldLayout = this.container.getLayout();
            final int oldStructure = this.container.getStructure();

            public void onFailure(Throwable arg0) {
                JsLibrary.log("save layout Failed");
            }

            public void onSuccess(Container c) {
                portal.updateColumnClassName(this.oldLayout, c.getLayout(), this.oldStructure, c.getStructure());
            }
        });
    }

    static void addGadget(String name) {
        SERVICE.addGadget(name, GWT_PARAMS, new AddGadgetAsyncCallback());
    }

    private static native String getInitialisationParams();

    private static native void createGwtContainerMask();

    private static native void attachLayoutManager(String var0, Integer var1);

    private static native String getContextPath();

    public static boolean waitForGadgetsValidation() {
        String dndValidation = GWT_PARAMS.get("dndValidation");
        return dndValidation != null && "true".equals(dndValidation.toLowerCase());
    }

    public static boolean showPreferencesAfterGadgetAddition() {
        String showPreferences = GWT_PARAMS.get("showPreferences");
        return showPreferences == null || "true".equals(showPreferences.toLowerCase());
    }
}

