/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.client.view;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.gwtext.client.dd.DropTargetConfig;
import com.gwtext.client.widgets.BoxComponent;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.MessageBoxConfig;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.layout.ColumnLayoutData;
import com.gwtext.client.widgets.layout.LayoutData;
import com.gwtext.client.widgets.portal.Portal;
import com.gwtext.client.widgets.portal.PortalColumn;
import com.gwtext.client.widgets.portal.Portlet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.opensocial.container.client.JsLibrary;
import org.nuxeo.opensocial.container.client.bean.Container;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;
import org.nuxeo.opensocial.container.client.bean.GadgetPosition;
import org.nuxeo.opensocial.container.client.view.DropZone;
import org.nuxeo.opensocial.container.client.view.GadgetPortlet;

public class ContainerPortal
extends Portal {
    private static final String PORTAL_CLASS = "containerPortal";
    private static final String MAXIMIZED_COL_ID = "maximizedCol";
    private static final String SPACER_CLASS = "x-panel-dd-spacer";
    private static final String COLUMN_ID_PREFIX = "column-";
    private PortalColumn maximizedCol;
    private final Container container;
    private final Map<String, PortalColumn> columns = new HashMap<String, PortalColumn>();
    private DropTargetConfig ddConfig;
    private final Panel panel;
    private final Map<String, GadgetPortlet> portlets = new HashMap<String, GadgetPortlet>();
    private final List<GadgetPortlet> collapsedCache = new ArrayList<GadgetPortlet>();
    private int loading;
    private static GadgetPortlet maximizedPortlet;

    public ContainerPortal(Container container, Panel parent) {
        this.container = container;
        this.panel = parent;
        this.buildPortal();
    }

    public ContainerPortal(Container container, Panel parent, DropTargetConfig ddConfig) {
        this(container, parent);
        this.ddConfig = ddConfig;
    }

    protected void afterRender() {
        new DropZone(this, this.ddConfig);
        this.loading = 0;
    }

    public Container getContainer() {
        return this.container;
    }

    public void buildPortal() {
        this.addClass(PORTAL_CLASS);
        this.setBorder(false);
        this.buildLayout();
        this.panel.add((Component)this);
        List<GadgetBean> gadgets = this.container.getGadgets();
        ArrayList<GadgetBean> lostGadgets = new ArrayList<GadgetBean>();
        for (GadgetBean bean : gadgets) {
            this.addGadget(bean, lostGadgets);
        }
        for (GadgetBean bean : lostGadgets) {
            this.addGadget(bean, null);
        }
    }

    public static String getColumnId(int n) {
        return COLUMN_ID_PREFIX + (n + 1);
    }

    private GadgetPortlet addGadget(GadgetBean bean, List<GadgetBean> lostGadgets) {
        GadgetPosition pos = bean.getGadgetPosition();
        PortalColumn col = null;
        if (pos.getPlaceID() != null) {
            col = this.columns.get(pos.getPlaceID());
        }
        if (col == null) {
            bean.getGadgetPosition().setPlaceId(ContainerPortal.getColumnId(0));
            lostGadgets.add(bean);
            return null;
        }
        GadgetPortlet gp = new GadgetPortlet(bean);
        col.add((Portlet)gp);
        this.portlets.put(gp.getId(), gp);
        col.doLayout();
        return gp;
    }

    public static void showErrorMessage(final String title, final String message) {
        MessageBox.show((MessageBoxConfig)new MessageBoxConfig(){
            {
                this.setTitle(title);
                this.setMsg(message);
                this.setClosable(true);
                this.setModal(true);
            }
        });
    }

    public GadgetPosition getDropPosition(String dragID) {
        for (PortalColumn col : this.columns.values()) {
            NodeList childs = col.getElement().getChildNodes();
            int position = 0;
            for (int i = 0; i < childs.getLength(); ++i) {
                Element elem = Element.as((Node)childs.getItem(i));
                if (SPACER_CLASS.equals(elem.getClassName())) {
                    return new GadgetPosition(col.getElement().getId(), position);
                }
                if (elem.getId().equals(dragID)) continue;
                ++position;
            }
        }
        return null;
    }

    public PortalColumn getPortalColumn(String id) {
        return this.columns.containsKey(id) ? this.columns.get(id) : null;
    }

    public GadgetPortlet getGadgetPortlet(String id) {
        return this.portlets.containsKey(id) ? this.portlets.get(id) : null;
    }

    public GadgetPortlet getGadgetPortletByRef(String ref) {
        if (this.maximizedCol.isHidden()) {
            String portletId = GadgetPortlet.getIdWithRefAndView(ref, "default");
            return this.getGadgetPortlet(portletId);
        }
        return maximizedPortlet;
    }

    public Collection<PortalColumn> getPortalColumns() {
        return this.columns.values();
    }

    public void toggleGadgetsCollapse() {
        for (GadgetPortlet p : this.portlets.values()) {
            if (p.isCollapsed()) continue;
            p.toggleCollapse();
            this.collapsedCache.add(p);
        }
    }

    public void clearGadgetsCollapse() {
        for (GadgetPortlet p : this.collapsedCache) {
            p.toggleCollapse();
            this.collapsedCache.remove((Object)p);
        }
    }

    private void buildLayout() {
        int structure = this.container.getStructure();
        if (structure == 0) {
            structure = 3;
        }
        this.createColumns(structure);
        this.createMaximizedCol();
    }

    private void createMaximizedCol() {
        this.maximizedCol = this.createCol(MAXIMIZED_COL_ID, 1.0);
        this.columns.remove(MAXIMIZED_COL_ID);
        this.maximizedCol.hide();
    }

    private void createColumns(int structure) {
        double width = 1.0 / (double)structure;
        for (int i = 0; i < structure; ++i) {
            this.createCol(ContainerPortal.getColumnId(i), width);
        }
    }

    private PortalColumn createCol(String id, double columnWidth) {
        PortalColumn col = new PortalColumn();
        col.setId(id);
        col.addClass(this.container.getLayout());
        this.add((Component)col, (LayoutData)new ColumnLayoutData(columnWidth));
        this.columns.put(id, col);
        return col;
    }

    public BoxComponent getPanel() {
        return this.panel;
    }

    public void removeGadgetPortlet(String id) {
        GadgetBean gadget = this.portlets.get(id).getGadgetBean();
        this.portlets.remove(id);
        GadgetPosition pos = gadget.getGadgetPosition();
        PortalColumn col = this.columns.get(pos.getPlaceID());
        if (col == null) {
            col = this.columns.get(ContainerPortal.getColumnId(0));
        }
        col.remove(id, true);
        col.doLayout();
    }

    public void incrementLoading() {
        if (this.loading < this.portlets.size()) {
            ++this.loading;
        }
    }

    private void replaceGadgetInDefaultPosition(GadgetPortlet portlet) {
        this.removeGadgetPortlet(portlet.getId());
        this.addGadget(portlet.getGadgetBean());
    }

    public GadgetPortlet addGadget(GadgetBean bean) {
        GadgetPosition gadgetPosition = bean.getPosition();
        String placeId = gadgetPosition.getPlaceID();
        if ("".equals(placeId)) {
            placeId = ContainerPortal.getDefaultColId();
            gadgetPosition.setPlaceId(placeId);
        }
        if (gadgetPosition.getPosition() == -1) {
            gadgetPosition.setPosition(this.columns.get(placeId).getItems().length);
        }
        bean.setHeight(-1);
        GadgetPortlet g = this.addGadget(bean, null);
        g.setVisible(true);
        this.columns.get(placeId).doLayout();
        return g;
    }

    public static String getDefaultColId() {
        return ContainerPortal.getColumnId(0);
    }

    public static Integer getDefaultPos() {
        return 0;
    }

    public void updateColumnClassName(String oldCls, String cls, int oldStructure, int structure) {
        this.container.setLayout(cls);
        this.container.setStructure(structure);
        for (PortalColumn col : this.columns.values()) {
            col.removeClass(oldCls);
            col.addClass(cls);
            col.doLayout();
        }
        this.removeOldColumns(oldStructure, structure);
        this.addNewColumns(oldStructure, structure);
        JsLibrary.updateColumnStyle();
        this.doLayout();
        JsLibrary.updateFrameWidth();
    }

    private void addNewColumns(int oldStructure, int structure) {
        for (int i = oldStructure; i < structure; ++i) {
            this.createCol(ContainerPortal.getColumnId(i), 0.25);
        }
        this.doLayout();
    }

    private void removeOldColumns(int oldStructure, int structure) {
        for (int i = oldStructure; i > structure; --i) {
            String colToDelete = ContainerPortal.getColumnId(i - 1);
            for (GadgetPortlet portlet : this.portlets.values()) {
                GadgetBean b = portlet.getGadgetBean();
                if (!b.getGadgetPosition().getPlaceID().equals(colToDelete)) continue;
                this.replaceGadgetInDefaultPosition(portlet);
            }
            this.columns.remove(colToDelete);
            this.remove(colToDelete, true);
        }
    }

    public PortalColumn getMaximizedCol() {
        return this.maximizedCol;
    }

    public static void setMaximizedPortlet(GadgetPortlet canvas) {
        maximizedPortlet = canvas;
    }

    public GadgetPortlet getGadgetPortletByFrameId(String frameId) {
        return this.maximizedCol.isHidden() ? this.getGadgetPortlet(GadgetPortlet.getIdWithIframeId(frameId)) : maximizedPortlet;
    }

    public void showPortlets() {
        for (GadgetPortlet p : this.portlets.values()) {
            p.setVisible(true);
        }
    }

    public int getColumnIndex(String colId) {
        return Integer.parseInt(colId.replaceFirst(COLUMN_ID_PREFIX, "")) - 1;
    }
}

