/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.nuxeo.opensocial.service.api.OpenSocialService;
import org.nuxeo.runtime.api.Framework;

public class SecureTokenBuilder {
    private static final Log log = LogFactory.getLog(SecureTokenBuilder.class);

    public static String getSecureToken(String viewer, String owner, String gadgetUrl) throws Exception {
        OpenSocialService svc = (OpenSocialService)Framework.getService(OpenSocialService.class);
        String container = "default";
        String domain = "localhost";
        if (svc.getPortalConfig() == null) {
            log.warn((Object)("portal configuration suggests that there are " + svc.getPortalConfig().length + " choices but we don't know how to pick the correct configuration!"));
        }
        return SecureTokenBuilder.getSecureToken(viewer, owner, gadgetUrl, svc.getSigningStateKeyBytes(), container, domain);
    }

    public static String getSecureToken(String viewer, String owner, String gadgetUrl, byte[] key, String container, String domain) throws Exception {
        BlobCrypterSecurityToken st = new BlobCrypterSecurityToken((BlobCrypter)new BasicBlobCrypter(key), container, domain);
        st.setViewerId(viewer);
        st.setOwnerId(owner);
        st.setAppUrl(gadgetUrl);
        return Utf8UrlCoder.encode((String)st.encrypt());
    }

    private static String XXXgetSecureToken(String viewer, String owner, String gadgetUrl, String key, String container, String domain) throws Exception {
        BlobCrypterSecurityToken st = new BlobCrypterSecurityToken((BlobCrypter)new BasicBlobCrypter(key.getBytes()), container, domain);
        st.setViewerId(viewer);
        st.setOwnerId(owner);
        st.setAppUrl(gadgetUrl);
        return Utf8UrlCoder.encode((String)st.encrypt());
    }
}

