/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.dashboard;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.international.LocaleSelector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.spaces.api.Gadget;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceException;
import org.nuxeo.ecm.spaces.core.contribs.impl.SingleDocSpaceProvider;
import org.nuxeo.opensocial.dashboard.TranslationHelper;
import org.nuxeo.runtime.api.Framework;

public class DashboardSpaceProvider
extends SingleDocSpaceProvider {
    public static final String DASHBOARD_SPACE_NAME = "dashboardSpace";
    public static final String DASHBOARD_UNIVERSE_NAME = "dashboardUniverse";
    public static final String DASHBOARD_DEFAULT_LAYOUT = "x-2-default";
    private static final Log log = LogFactory.getLog(DashboardSpaceProvider.class);

    public Space doGetSpace(String name, CoreSession session) throws SpaceException {
        if (!name.equals(DASHBOARD_SPACE_NAME)) {
            throw new SpaceException("Only one space is supported by the dashboard space provider!");
        }
        try {
            DocumentModel space = DashboardSpaceProvider.getOrCreateSpace(session);
            return (Space)space.getAdapter(Space.class);
        }
        catch (ClientException e) {
            log.error((Object)"Unable to create or get personal dashboard", (Throwable)e);
            return null;
        }
    }

    public static String getSpaceId(CoreSession session) throws ClientException {
        DocumentModel doc = DashboardSpaceProvider.getOrCreateSpace(session);
        return doc.getId();
    }

    protected static DocumentModel getUserPersonalWorkspace(CoreSession session) {
        try {
            UserWorkspaceService svc = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
            if (svc == null) {
                throw new SpaceException("Can't find the user workspace service!");
            }
            return svc.getCurrentUserPersonalWorkspace(session, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static DocumentModel getOrCreateParentUnivers(CoreSession session) throws ClientException {
        DocumentModel universeDoc;
        DocumentModel pw = DashboardSpaceProvider.getUserPersonalWorkspace(session);
        if (pw == null) {
            throw new ClientException("Unable to get personal workspace");
        }
        PathRef universePath = new PathRef(DashboardSpaceProvider.getUserPersonalWorkspace(session).getPathAsString() + "/" + DASHBOARD_UNIVERSE_NAME);
        if (session.exists((DocumentRef)universePath)) {
            universeDoc = session.getDocument((DocumentRef)universePath);
        } else {
            universeDoc = session.createDocumentModel(DashboardSpaceProvider.getUserPersonalWorkspace(session).getPathAsString(), DASHBOARD_UNIVERSE_NAME, "HiddenFolder");
            universeDoc.setProperty("dc", "title", (Object)"nuxeo dashboard universe");
            universeDoc.setProperty("dc", "description", (Object)"parent of dashboard space");
            universeDoc = session.createDocument(universeDoc);
            session.saveDocument(universeDoc);
            session.save();
        }
        return universeDoc;
    }

    protected static DocumentModel getOrCreateSpace(CoreSession session) throws ClientException {
        DocumentModel parentUnivers = DashboardSpaceProvider.getOrCreateParentUnivers(session);
        PathRef spaceRef = new PathRef(parentUnivers.getPathAsString() + "/" + DASHBOARD_SPACE_NAME);
        if (session.exists((DocumentRef)spaceRef)) {
            return session.getDocument((DocumentRef)spaceRef);
        }
        DocumentModel model = session.createDocumentModel(DashboardSpaceProvider.getUserPersonalWorkspace(session).getPathAsString() + "/" + DASHBOARD_UNIVERSE_NAME, DASHBOARD_SPACE_NAME, "Space");
        model.setProperty("dc", "title", (Object)"nuxeo dashboard space");
        model.setProperty("dc", "description", (Object)"dashboard space");
        Space desiredSpace = (Space)model.getAdapter(Space.class);
        desiredSpace.setLayout(DASHBOARD_DEFAULT_LAYOUT);
        model = session.createDocument(model);
        DashboardSpaceProvider.createInitialGadgets(session, model);
        session.save();
        return model;
    }

    protected static void createInitialGadgets(CoreSession session, DocumentModel spaceDocument) throws ClientException {
        LocaleSelector localeSelector = (LocaleSelector)Component.getInstance((String)"org.jboss.seam.international.localeSelector");
        String language = "en";
        if (localeSelector != null) {
            language = localeSelector.getLanguage();
        }
        String labelKey = "";
        String title = "";
        Space space = (Space)spaceDocument.getAdapter(Space.class);
        log.debug((Object)"creating UserTasks ");
        labelKey = "title.dashboard.userTasks";
        title = TranslationHelper.getLabel(labelKey, language);
        DashboardSpaceProvider.createGadgetForInitialDashboard(session, space, "tasks", title, DashboardSpaceProvider.getColumnId((int)0), new Integer(0));
        log.debug((Object)"creating waiting for ");
        labelKey = "title.dashboard.waitingfor";
        title = TranslationHelper.getLabel(labelKey, language);
        DashboardSpaceProvider.createGadgetForInitialDashboard(session, space, "waitingfor", title, DashboardSpaceProvider.getColumnId((int)0), new Integer(1));
        log.debug((Object)"creating UserSites ");
        labelKey = "title.dashboard.userSites";
        title = TranslationHelper.getLabel(labelKey, language);
        DashboardSpaceProvider.createGadgetForInitialDashboard(session, space, "usersites", title, DashboardSpaceProvider.getColumnId((int)0), new Integer(2));
        log.debug((Object)"creating UserDocuments ");
        labelKey = "title.dashboard.userDocuments";
        title = TranslationHelper.getLabel(labelKey, language);
        DashboardSpaceProvider.createGadgetForInitialDashboard(session, space, "userdocuments", title, DashboardSpaceProvider.getColumnId((int)1), new Integer(0));
        log.debug((Object)"creating UserWorkspaces ");
        labelKey = "title.dashboard.userWorkspaces";
        title = TranslationHelper.getLabel(labelKey, language);
        DashboardSpaceProvider.createGadgetForInitialDashboard(session, space, "userworkspaces", title, DashboardSpaceProvider.getColumnId((int)1), new Integer(0));
        session.save();
    }

    protected static Gadget createGadgetForInitialDashboard(CoreSession session, Space parent, String name, String title, String placeId, Integer position) throws ClientException {
        Gadget gadget = parent.createGadget(name);
        gadget.setCategory(null);
        gadget.setCollapsed(Boolean.FALSE.booleanValue());
        gadget.setPlaceId(placeId);
        gadget.setPosition(position.intValue());
        gadget.setPreferences(new HashMap());
        gadget.setTitle(title);
        parent.save(gadget);
        log.debug((Object)("created a gadget: " + name + "," + gadget.getPlaceId()));
        return gadget;
    }
}

