/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.dashboard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceException;
import org.nuxeo.ecm.webapp.dashboard.DashboardNavigationHelper;
import org.nuxeo.opensocial.container.component.api.FactoryManager;
import org.nuxeo.opensocial.dashboard.DashboardSpaceProvider;
import org.nuxeo.opensocial.gadgets.service.api.GadgetDeclaration;
import org.nuxeo.opensocial.gadgets.service.api.GadgetService;
import org.nuxeo.runtime.api.Framework;

@Name(value="opensocialDashboard")
@Scope(value=ScopeType.SESSION)
@Startup
public class Dashboard
implements Serializable {
    private static final long serialVersionUID = 8748161330761041337L;
    private static final Log log = LogFactory.getLog(Dashboard.class);
    public static final String OLD_DASHBARD_VIEWID = "user_dashboard";
    public static final String NEW_DASHBARD_VIEWID = "opensocial_dashboard";
    public static final String DASHBARD_MODE_PROPERTY = "org.nuxeo.ecm.webapp.dashboard.viewid";
    public static final String SELENIUM_USERAGENT = "Nuxeo-Selenium-Tester";
    protected String selectedDomainId;
    protected DocumentModelList domains = null;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(required=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected DashboardNavigationHelper dashboardNavigationHelper;
    protected DocumentModel lastAccessedDocument;

    public String getPersonalDashboardId() {
        try {
            return DashboardSpaceProvider.getSpaceId(this.documentManager);
        }
        catch (SpaceException e) {
            log.error((Object)"Unable to access space correctly for our dashboard!", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error attempting to find the SpaceManager!", (Throwable)e);
        }
        return null;
    }

    public boolean isAnonymous() {
        NuxeoPrincipal principal = (NuxeoPrincipal)this.documentManager.getPrincipal();
        return principal.isAnonymous();
    }

    @Factory(value="dashboardGadgetCategories", scope=ScopeType.EVENT)
    public List<String> getCategories() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            FactoryManager factoryManager = (FactoryManager)Framework.getService(FactoryManager.class);
            for (String s : factoryManager.getContainerFactory().getGadgetList().keySet()) {
                result.add(s);
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to find factory or container manager!", (Throwable)e);
        }
        return result;
    }

    @Factory(value="dashboardGadgets", scope=ScopeType.EVENT)
    public List<Map<String, String>> getGadgets() {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try {
            FactoryManager factoryManager = (FactoryManager)Framework.getService(FactoryManager.class);
            GadgetService gadgetService = (GadgetService)Framework.getService(GadgetService.class);
            Map gadgetList = factoryManager.getContainerFactory().getGadgetList();
            for (String category : gadgetList.keySet()) {
                ArrayList inCategory = (ArrayList)gadgetList.get(category);
                for (String gadgetName : inCategory) {
                    HashMap<String, String> gadgetText = new HashMap<String, String>();
                    gadgetText.put("name", gadgetName);
                    gadgetText.put("category", category);
                    GadgetDeclaration gadget = gadgetService.getGadget(gadgetName);
                    gadgetText.put("iconUrl", gadget.getIconUrl());
                    result.add(gadgetText);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to find factory or container manager!", (Throwable)e);
        }
        return result;
    }

    public String toString() {
        return "opensocial dashboard:" + this.getCategories() + " categories";
    }

    @Factory(value="opensocialNuxeoServerUrl", scope=ScopeType.APPLICATION)
    public String getNuxeoServerUrl() {
        String host = Framework.getProperty((String)"gadgets.host", (String)"127.0.0.1");
        String port = Framework.getProperty((String)"gadgets.port", (String)"8080");
        return "http://" + host + ":" + port + "/";
    }

    public void dumpDocumentInfo(String docId) {
        try {
            String[] schemaNames;
            IdRef ref = new IdRef(docId);
            DocumentModel model = this.documentManager.getDocument((DocumentRef)ref);
            log.info((Object)("------------- doc id " + docId + " ---------------------"));
            log.info((Object)("document type:" + model.getDocumentType().getName()));
            log.info((Object)("document path:" + model.getPathAsString()));
            for (String schemaName : schemaNames = model.getDocumentType().getSchemaNames()) {
                log.info((Object)("dumping schema:" + schemaName + " ++++++++++++++"));
                Map propMap = model.getProperties(schemaName);
                for (String propName : propMap.keySet()) {
                    if (propMap.get(propName) == null) {
                        log.info((Object)("" + propName + "  ---> NULL"));
                        continue;
                    }
                    if (propMap.get(propName) instanceof GregorianCalendar) {
                        GregorianCalendar calendar = (GregorianCalendar)propMap.get(propName);
                        log.info((Object)("" + propName + " ---> " + calendar.getTimeInMillis()));
                        continue;
                    }
                    String propValue = propMap.get(propName).toString();
                    log.info((Object)("" + propName + " ---> " + propValue));
                }
            }
            if (model.getDocumentType().getName().equals("Space")) {
                DocumentModelList list = this.documentManager.query("SELECT * FROM Document WHERE ecm:path STARTSWITH '" + model.getPathAsString() + "'");
                for (DocumentModel documentModel : list) {
                    this.dumpDocumentInfo(documentModel.getId());
                }
            }
        }
        catch (ClientException e) {
            log.error((Object)"unable to dump document information!", (Throwable)e);
        }
    }

    public String goToDashBoard() {
        String dashboardViewId = this.dashboardNavigationHelper.navigateToDashboard();
        if (NEW_DASHBARD_VIEWID.equals(dashboardViewId)) {
            this.lastAccessedDocument = this.navigationContext.getCurrentDocument();
        }
        return dashboardViewId;
    }

    public String exit() throws Exception {
        if (this.lastAccessedDocument == null) {
            return this.navigationContext.goHome();
        }
        return this.navigationContext.navigateToDocument(this.lastAccessedDocument);
    }

    public String getSelectedDomain() throws ClientException {
        if (this.selectedDomainId == null) {
            this.selectedDomainId = this.getCurrentDashboardDomainName();
        }
        return this.selectedDomainId;
    }

    public void setSelectedDomain(String selectedDomain) {
        this.selectedDomainId = selectedDomain;
    }

    public List<SelectItem> getDomainsSelectItems() throws ClientException {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        SelectItem rootitem = new SelectItem((Object)"*", "All");
        items.add(rootitem);
        DocumentModelList domains = this.getAccessibleDomains();
        for (DocumentModel domain : domains) {
            SelectItem item = new SelectItem((Object)domain.getName(), domain.getTitle());
            items.add(item);
        }
        return items;
    }

    protected DocumentModelList getAccessibleDomains() throws ClientException {
        if (this.domains == null) {
            this.domains = this.documentManager.query("select * from Domain order by dc:created");
        }
        return this.domains;
    }

    public String submitSelectedDomainChange() throws ClientException {
        return null;
    }

    public String getCurrentDashboardDomainName() throws ClientException {
        if (this.selectedDomainId == null) {
            DocumentModelList domains;
            DocumentModel currentDomain = this.navigationContext.getCurrentDomain();
            if (currentDomain == null && (domains = this.getAccessibleDomains()).size() > 0) {
                currentDomain = (DocumentModel)domains.get(0);
            }
            if (currentDomain == null) {
                return "*";
            }
            return currentDomain.getName();
        }
        return this.selectedDomainId;
    }
}

