/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.dashboard;

import java.io.Serializable;
import java.security.Principal;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceException;
import org.nuxeo.ecm.webapp.dashboard.DashboardNavigationHelper;
import org.nuxeo.opensocial.dashboard.DashboardSpaceProvider;
import org.nuxeo.runtime.api.Framework;

@Name(value="dashboardNavigationHelper")
@Scope(value=ScopeType.SESSION)
public class OpensocialDashboardNavigationHelper
implements DashboardNavigationHelper,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String OLD_DASHBARD_VIEWID = "user_dashboard";
    public static final String NEW_DASHBARD_VIEWID = "opensocial_dashboard";
    public static final String DASHBARD_MODE_PROPERTY = "org.nuxeo.ecm.webapp.dashboard.mode";
    public static final String DASHBARD_MODE_AUTO = "auto";
    public static final String DASHBARD_MODE_OS = "opensocial";
    public static final String DASHBARD_MODE_OLD = "old";
    public static final String SELENIUM_USERAGENT = "Nuxeo-Selenium-Tester";
    public static final String MSIE_USERAGENT = "MSIE";
    public static final String MSIE7_USERAGENT = "MSIE 7.";
    public static final String MSIE8_USERAGENT = "MSIE 8.";
    public static final String SAFARI_USERAGENT = "Safari";
    private static final Log log = LogFactory.getLog(OpensocialDashboardNavigationHelper.class);
    protected String dashBoardViewId = null;
    @In(create=true, required=false)
    protected CoreSession documentManager;
    protected boolean personnalDashboardCreated = false;

    public String navigateToDashboard() {
        this.createPersonnalDashbordIfNeeded();
        return this.computeDashbordView();
    }

    protected void createPersonnalDashbordIfNeeded() {
        if (!this.personnalDashboardCreated) {
            String string = this.getPersonalDashboardContainerIdRef();
        }
    }

    @Factory(value="personalDashboardContainerIdRef", scope=ScopeType.SESSION)
    public String getPersonalDashboardContainerIdRef() {
        try {
            return DashboardSpaceProvider.getSpaceId(this.documentManager);
        }
        catch (SpaceException e) {
            log.error((Object)"Unable to access space correctly for our dashboard!", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error attempting to find the SpaceManager!", (Throwable)e);
        }
        return null;
    }

    protected String computeDashbordView() {
        if (this.dashBoardViewId == null) {
            Principal principal;
            String userAgent = null;
            FacesContext fContext = FacesContext.getCurrentInstance();
            if (fContext == null) {
                log.error((Object)"unable to fetch facesContext, can not detect client type");
            } else {
                userAgent = (String)fContext.getExternalContext().getRequestHeaderMap().get("User-Agent");
            }
            if (userAgent != null && userAgent.contains(SELENIUM_USERAGENT)) {
                return OLD_DASHBARD_VIEWID;
            }
            if (this.documentManager != null && this.documentManager.getPrincipal() != null && (principal = this.documentManager.getPrincipal()) instanceof NuxeoPrincipal && ((NuxeoPrincipal)principal).isAnonymous()) {
                return OLD_DASHBARD_VIEWID;
            }
            String mode = Framework.getProperty((String)DASHBARD_MODE_PROPERTY, (String)DASHBARD_MODE_AUTO);
            if (DASHBARD_MODE_AUTO.equals(mode)) {
                this.dashBoardViewId = userAgent != null && userAgent.contains(MSIE_USERAGENT) ? (userAgent.contains(MSIE7_USERAGENT) ? NEW_DASHBARD_VIEWID : (userAgent.contains(MSIE8_USERAGENT) ? NEW_DASHBARD_VIEWID : OLD_DASHBARD_VIEWID)) : (userAgent != null && userAgent.contains(SAFARI_USERAGENT) ? NEW_DASHBARD_VIEWID : NEW_DASHBARD_VIEWID);
            } else if (DASHBARD_MODE_OS.equals(mode)) {
                this.dashBoardViewId = NEW_DASHBARD_VIEWID;
            } else if (DASHBARD_MODE_OLD.equals(mode)) {
                this.dashBoardViewId = OLD_DASHBARD_VIEWID;
            }
        }
        return this.dashBoardViewId;
    }
}

