/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.dashboard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.SpaceManager;
import org.nuxeo.ecm.webapp.dashboard.DashboardNavigationHelper;
import org.nuxeo.runtime.api.Framework;

@Name(value="opensocialDashboard")
@Scope(value=ScopeType.SESSION)
@Startup
public class Dashboard
implements Serializable {
    private static final long serialVersionUID = 8748161330761041337L;
    private static final Log log = LogFactory.getLog(Dashboard.class);
    protected String selectedDomainId;
    protected DocumentModelList domains = null;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(required=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected DashboardNavigationHelper dashboardNavigationHelper;
    protected DocumentModel lastAccessedDocument;

    public boolean isAnonymous() {
        NuxeoPrincipal principal = (NuxeoPrincipal)this.documentManager.getPrincipal();
        return principal.isAnonymous();
    }

    @Factory(value="opensocialNuxeoServerUrl", scope=ScopeType.APPLICATION)
    public String getNuxeoServerUrl() {
        String host = Framework.getProperty((String)"gadgets.host", (String)"127.0.0.1");
        String port = Framework.getProperty((String)"gadgets.port", (String)"8080");
        return "http://" + host + ":" + port + "/";
    }

    public String goToDashBoard() {
        String dashboardViewId = this.dashboardNavigationHelper.navigateToDashboard();
        if ("opensocial_dashboard".equals(dashboardViewId)) {
            this.lastAccessedDocument = this.navigationContext.getCurrentDocument();
        }
        return dashboardViewId;
    }

    public String exit() throws Exception {
        if (this.lastAccessedDocument == null) {
            return this.navigationContext.goHome();
        }
        return this.navigationContext.navigateToDocument(this.lastAccessedDocument);
    }

    public String getSelectedDomain() throws ClientException {
        if (this.selectedDomainId == null) {
            this.selectedDomainId = this.getCurrentDashboardDomainName();
        }
        return this.selectedDomainId;
    }

    public void setSelectedDomain(String selectedDomain) {
        this.selectedDomainId = selectedDomain;
    }

    public List<SelectItem> getDomainsSelectItems() throws ClientException {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        SelectItem rootitem = new SelectItem((Object)"*", "All");
        items.add(rootitem);
        DocumentModelList domains = this.getAccessibleDomains();
        for (DocumentModel domain : domains) {
            SelectItem item = new SelectItem((Object)domain.getName(), domain.getTitle());
            items.add(item);
        }
        return items;
    }

    protected DocumentModelList getAccessibleDomains() throws ClientException {
        if (this.domains == null) {
            this.domains = this.documentManager.query("select * from Domain order by dc:created");
        }
        return this.domains;
    }

    public String submitSelectedDomainChange() throws ClientException {
        return null;
    }

    public String getCurrentDashboardDomainName() throws ClientException {
        if (this.selectedDomainId == null) {
            DocumentModelList domains;
            DocumentModel currentDomain = this.navigationContext.getCurrentDomain();
            if (currentDomain == null && (domains = this.getAccessibleDomains()).size() > 0) {
                currentDomain = (DocumentModel)domains.get(0);
            }
            if (currentDomain == null) {
                return "*";
            }
            return currentDomain.getName();
        }
        return this.selectedDomainId;
    }

    public String initializeSpace(String spaceName, String spaceProviderName) throws Exception {
        SpaceManager spaceManager = (SpaceManager)Framework.getService(SpaceManager.class);
        Space space = spaceManager.getSpace(spaceProviderName, this.navigationContext.getCurrentDocument(), spaceName);
        return space.getId();
    }

    public String getSpaceId(String spaceName, String spaceProviderName, DocumentModel contextDocument) throws Exception {
        SpaceManager spaceManager = (SpaceManager)Framework.getService(SpaceManager.class);
        Space space = spaceManager.getSpace(spaceProviderName, contextDocument, spaceName);
        return space.getId();
    }
}

