/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.dashboard;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.spaces.api.AbstractSpaceProvider;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.api.exceptions.SpaceException;
import org.nuxeo.opensocial.container.shared.layout.api.LayoutHelper;
import org.nuxeo.runtime.api.Framework;

public class DashboardSpaceProvider
extends AbstractSpaceProvider {
    public static final String DASHBOARD_SPACE_NAME = "userDashboardSpace";
    private static final Log log = LogFactory.getLog(DashboardSpaceProvider.class);

    protected Space doGetSpace(CoreSession session, DocumentModel contextDocument, String spaceName) throws SpaceException {
        try {
            return DashboardSpaceProvider.getOrCreateSpace(session);
        }
        catch (ClientException e) {
            log.error((Object)"Unable to create or get personal dashboard", (Throwable)e);
            return null;
        }
    }

    protected static DocumentModel getUserPersonalWorkspace(CoreSession session) throws ClientException {
        try {
            UserWorkspaceService svc = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
            return svc.getCurrentUserPersonalWorkspace(session, null);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected static Space getOrCreateSpace(CoreSession session) throws ClientException {
        String userWorkspacePath = DashboardSpaceProvider.getUserPersonalWorkspace(session).getPathAsString();
        PathRef spaceRef = new PathRef(userWorkspacePath, DASHBOARD_SPACE_NAME);
        if (session.exists((DocumentRef)spaceRef)) {
            DocumentModel existingSpace = session.getDocument((DocumentRef)spaceRef);
            return (Space)existingSpace.getAdapter(Space.class);
        }
        DocumentModel model = session.createDocumentModel(userWorkspacePath, DASHBOARD_SPACE_NAME, "Space");
        model.setPropertyValue("dc:title", (Serializable)((Object)"nuxeo dashboard space"));
        model.setPropertyValue("dc:description", (Serializable)((Object)"dashboard space"));
        model = session.createDocument(model);
        session.save();
        Space space = (Space)model.getAdapter(Space.class);
        space.initLayout(LayoutHelper.buildLayout((LayoutHelper.Preset)LayoutHelper.Preset.X_2_66_33));
        return space;
    }

    public boolean isReadOnly(CoreSession session) {
        return true;
    }
}

