/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.service.impl;

import com.google.inject.Injector;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.ProxySelector;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.nuxeo.opensocial.service.api.OpenSocialService;
import org.nuxeo.opensocial.service.impl.SimpleProxySelector;
import org.nuxeo.opensocial.servlet.GuiceContextListener;
import org.nuxeo.opensocial.shindig.crypto.OAuthServiceDescriptor;
import org.nuxeo.opensocial.shindig.crypto.OpenSocialDescriptor;
import org.nuxeo.opensocial.shindig.crypto.PortalConfig;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class OpenSocialServiceImpl
extends DefaultComponent
implements OpenSocialService {
    private static final Log log = LogFactory.getLog(OpenSocialServiceImpl.class);
    public static final String ID = "org.nuxeo.opensocial.service.impl.OpenSocialServiceImpl";
    public static final ComponentName NAME = new ComponentName("org.nuxeo.opensocial.service.impl.OpenSocialServiceImpl");
    private static final Log LOG = LogFactory.getLog(OpenSocialService.class);
    private static final String XP_OPENSOCIAL = "openSocialConfig";
    private static Injector injector;
    protected File signingStateKeyFile;
    protected OpenSocialDescriptor os;
    private final Map<String, String> keys = new HashMap<String, String>();
    protected File oauthPrivateKeyFile;
    protected String signingStateKeyBytes;

    public Injector getInjector() {
        return injector;
    }

    @Override
    public GadgetSpecFactory getGadgetSpecFactory() {
        return (GadgetSpecFactory)injector.getInstance(GadgetSpecFactory.class);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (XP_OPENSOCIAL.equals(extensionPoint)) {
            this.os = (OpenSocialDescriptor)contribution;
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        try {
            return (T)this.getInjector().getInstance(adapter);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void activate(ComponentContext context) throws Exception {
        LOG.info((Object)"Activate component OpenSocial service");
        if (injector == null) {
            injector = GuiceContextListener.guiceInjector;
        }
    }

    public void deactivate(ComponentContext arg0) {
        LOG.info((Object)"DeActivate component OpenSocial service");
    }

    public Object getInstance(Class<?> klass) {
        if (this.getInjector() != null) {
            return this.getInjector().getInstance(klass);
        }
        return null;
    }

    @Override
    public void setInjector(Injector injector) {
        OpenSocialServiceImpl.injector = injector;
    }

    @Override
    public String getKeyForContainer(String defaultContainer) {
        return this.keys.get(defaultContainer);
    }

    @Override
    public ProxySelector getProxySelector() {
        return new SimpleProxySelector();
    }

    @Override
    public void setupOpenSocial() throws Exception {
        if (this.os == null) {
            log.warn((Object)"OpenSocial does not have any configuration contribution ... setup canceled");
            return;
        }
        if (StringUtils.isBlank((String)this.os.getSigningKey())) {
            byte[] b64 = Base64.encodeBase64((byte[])Crypto.getRandomBytes((int)16));
            this.os.setSigningKey(new String(b64, "UTF-8"));
        }
        try {
            this.signingStateKeyFile = this.createTempFileForAKey(this.os.getSigningKey());
            System.setProperty("shindig.signing.state-key", this.signingStateKeyFile.getPath());
        }
        catch (IOException e) {
            log.warn((Object)("ignoring signing key " + this.os.getSigningKey() + " because we cannot write temp file!"), (Throwable)e);
        }
        if (!StringUtils.isBlank((String)this.os.getExternalPrivateKey())) {
            String name = this.os.getExternalPrivateKeyName();
            if (StringUtils.isBlank((String)name)) {
                log.warn((Object)"no key name provided for oauth external private key  so we are using default name of 'nuxeo'");
                name = "nuxeo";
            }
            this.oauthPrivateKeyFile = this.createTempFileForAKey(this.os.getExternalPrivateKey());
            System.setProperty("shindig.signing.key-file", this.oauthPrivateKeyFile.getPath());
            System.setProperty("shindig.signing.key-name", name);
        } else {
            log.warn((Object)"OAuth is not likely to work properly for dashboard because no external private key was found");
        }
        if (StringUtils.isBlank((String)this.os.getCallbackUrl())) {
            throw new Exception("Unable to start because the global callback url is not set.  See default-opensocial-config.xml");
        }
        System.setProperty("shindig.signing.global-callback-url", this.os.getCallbackUrl());
    }

    protected File createTempFileForAKey(String keyValue) throws IOException {
        File f = File.createTempFile("nxkey", ".txt");
        f.deleteOnExit();
        FileWriter writer = new FileWriter(f);
        writer.append(keyValue);
        writer.flush();
        writer.close();
        return f;
    }

    @Override
    public File getSigningStateKeyFile() {
        return this.signingStateKeyFile;
    }

    @Override
    public PortalConfig[] getPortalConfig() {
        return this.os.getPortalConfig();
    }

    @Override
    public File getOAuthPrivateKeyFile() {
        return this.oauthPrivateKeyFile;
    }

    @Override
    public OAuthServiceDescriptor[] getOAuthServices() {
        return this.os.getOAuthServices();
    }

    @Override
    public String getOAuthCallbackUrl() {
        return this.os.getCallbackUrl();
    }

    @Override
    public String getOAuthPrivateKeyName() {
        return this.os.getExternalPrivateKeyName();
    }

    @Override
    public String[] getTrustedHosts() {
        return this.os.getTrustedHosts();
    }

    @Override
    public byte[] getSigningStateKeyBytes() {
        try {
            if (this.signingStateKeyBytes == null) {
                this.signingStateKeyBytes = IOUtils.toString((Reader)new FileReader(this.getSigningStateKeyFile()));
            }
            return this.signingStateKeyBytes.getBytes();
        }
        catch (FileNotFoundException e) {
            log.error((Object)"Unable to find the signing key file! Check default-opensocial-contrib.xml!", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            log.error((Object)"Unable to read the signing key file! Check default-opensocial-contrib.xml!", (Throwable)e);
            return null;
        }
    }
}

