/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.servlet;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.tools.jmx.Manager;
import com.google.inject.util.Modules;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.gadgets.oauth.OAuthModule;
import org.nuxeo.opensocial.service.api.OpenSocialService;
import org.nuxeo.opensocial.servlet.NuxeoRequestOverrides;
import org.nuxeo.runtime.api.Framework;

public class GuiceContextListener
implements ServletContextListener {
    public static final String INJECTOR_ATTRIBUTE = "guice-injector";
    public static final String MODULES_ATTRIBUTE = "guice-modules";
    protected boolean jmxInitialized = false;
    private static final Log log = LogFactory.getLog(GuiceContextListener.class);
    public static Injector guiceInjector = null;
    protected List<Module> modules;
    protected ServletContext context;

    public void contextInitialized(ServletContextEvent event) {
        log.info((Object)"GuiceContextListener contextInitialized");
        this.context = event.getServletContext();
        this.modules = this.getModuleList(this.context.getInitParameter(MODULES_ATTRIBUTE));
        log.info((Object)"GuiceContextListener getModuleList");
        try {
            this.runInjection();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot find opensocial service for initialization!", e);
        }
    }

    protected void runInjection() {
        Injector injector = null;
        try {
            log.info((Object)"GuiceContextListener createInjector");
            this.modules.add(Modules.override((Module[])new Module[]{new OAuthModule()}).with(new Module[]{new NuxeoRequestOverrides()}));
            injector = Guice.createInjector((Stage)Stage.PRODUCTION, this.modules);
            OpenSocialService service = (OpenSocialService)Framework.getService(OpenSocialService.class);
            if (service != null) {
                service.setInjector(injector);
            } else {
                guiceInjector = injector;
            }
            this.context.setAttribute(INJECTOR_ATTRIBUTE, (Object)injector);
        }
        catch (Exception e) {
            log.error((Object)"GuiceContextListener caught exception during injection process", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            if (!this.jmxInitialized) {
                Manager.manage((String)"ShindigGuiceContext", (Injector)injector);
                this.jmxInitialized = true;
            }
        }
        catch (Exception e) {
            log.error((Object)"GuiceContextListener caught exception trying to init shindig guice context (JMX):", (Throwable)e);
        }
    }

    private Module getModuleInstance(String moduleName) throws InstantiationException {
        try {
            return (Module)Class.forName(moduleName).newInstance();
        }
        catch (IllegalAccessException e) {
            InstantiationException ie = new InstantiationException("IllegalAccessException: " + e.getMessage());
            ie.setStackTrace(e.getStackTrace());
            throw ie;
        }
        catch (ClassNotFoundException e) {
            InstantiationException ie = new InstantiationException("ClassNotFoundException: " + e.getMessage());
            ie.setStackTrace(e.getStackTrace());
            throw ie;
        }
    }

    private List<Module> getModuleList(String moduleNames) {
        LinkedList<Module> modules = new LinkedList<Module>();
        if (moduleNames != null) {
            for (String moduleName : moduleNames.split(":")) {
                try {
                    moduleName = moduleName.trim();
                    if (moduleName.length() <= 0) continue;
                    Module moduleInstance = this.getModuleInstance(moduleName);
                    modules.add(moduleInstance);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return modules;
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        context.removeAttribute(INJECTOR_ATTRIBUTE);
    }
}

