/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.shindig.crypto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.opensocial.shindig.crypto.OAuthServiceDescriptor;
import org.nuxeo.opensocial.shindig.crypto.PortalConfig;
import org.nuxeo.runtime.api.Framework;

@XObject(value="opensocial")
public class OpenSocialDescriptor {
    public static final String TRUSTED_HOSTS_SEPARATOR = ",";
    public static final String NUXEO_BIND_ADDRESS_PROPERTY = "nuxeo.bind.address";
    public static final String LOCALHOST_BIND_ADDRESS = "localhost";
    public static final Pattern DEFAULT_BIND_ADDRESS_PATTERN = Pattern.compile("[0:]*|[0.]*");
    @XNode(value="signingKey")
    protected String signingKey;
    @XNode(value="oauthCallbackUrl")
    protected String callbackUrl;
    @XNode(value="propagateJSESSIONIDToTrustedHosts")
    protected boolean propagateJSESSIONIDToTrustedHosts = false;
    @XNodeList(value="portals/portalConfig", type=PortalConfig[].class, componentType=PortalConfig.class)
    protected PortalConfig[] portal;
    protected List<String> trustedHosts = new ArrayList<String>();
    @XNodeList(value="oauthservices/oauthservice", type=OAuthServiceDescriptor[].class, componentType=OAuthServiceDescriptor.class)
    protected OAuthServiceDescriptor[] services;

    public String getSigningKey() {
        return this.signingKey;
    }

    public PortalConfig[] getPortalConfig() {
        return this.portal;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setSigningKey(String keyAsBase64) {
        this.signingKey = keyAsBase64;
    }

    @XNode(value="trustedHosts")
    public void setTrustedHosts(String trustedHosts) {
        String allTrustedHosts = this.getTrustedHostForNuxeoBindAddress();
        if (trustedHosts != null && !trustedHosts.isEmpty()) {
            allTrustedHosts = allTrustedHosts + TRUSTED_HOSTS_SEPARATOR + trustedHosts;
        }
        this.trustedHosts.addAll(Arrays.asList(allTrustedHosts.split(TRUSTED_HOSTS_SEPARATOR)));
    }

    protected String getTrustedHostForNuxeoBindAddress() {
        String nuxeoBindAddress = Framework.getProperty((String)NUXEO_BIND_ADDRESS_PROPERTY, (String)LOCALHOST_BIND_ADDRESS);
        if (DEFAULT_BIND_ADDRESS_PATTERN.matcher(nuxeoBindAddress).matches()) {
            nuxeoBindAddress = LOCALHOST_BIND_ADDRESS;
        }
        return nuxeoBindAddress;
    }

    public String[] getTrustedHosts() {
        return this.trustedHosts.toArray(new String[this.trustedHosts.size()]);
    }

    public boolean isTrustedHost(String host) {
        if ((host.equals(LOCALHOST_BIND_ADDRESS) || host.startsWith("127.")) && this.trustedHosts.contains(LOCALHOST_BIND_ADDRESS)) {
            return true;
        }
        return this.trustedHosts.contains(host);
    }

    public OAuthServiceDescriptor[] getOAuthServices() {
        return this.services;
    }

    public boolean propagateJSESSIONIDToTrustedHosts() {
        return this.propagateJSESSIONIDToTrustedHosts;
    }
}

