/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.webengine.gadgets;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.opensocial.container.server.utils.SecureTokenBuilder;
import org.nuxeo.opensocial.gadgets.service.api.GadgetDeclaration;
import org.nuxeo.opensocial.gadgets.service.api.GadgetService;
import org.nuxeo.runtime.api.Framework;

@Path(value="/gadgets")
@WebObject(type="gadgets")
@Produces(value={"text/html; charset=UTF-8"})
public class Gadgets
extends ModuleRoot {
    private final GadgetService gm = (GadgetService)Framework.getService(GadgetService.class);

    @GET
    public Object getGallery(@QueryParam(value="cat") String category, @QueryParam(value="mode") String mode, @QueryParam(value="language") String language) {
        List gadgetList;
        if (language == null) {
            language = "en";
        }
        this.getContext().setLocale(new Locale(language));
        String ftlName = null;
        if (mode == null) {
            mode = "gallery";
        }
        if (mode.equalsIgnoreCase("gallery")) {
            ftlName = "gallery";
        } else if (mode.equalsIgnoreCase("popup")) {
            ftlName = "chooser-body";
        } else {
            return Response.serverError().build();
        }
        if (category == null) {
            gadgetList = this.gm.getGadgetList();
            category = "all";
        } else {
            gadgetList = this.gm.getGadgetList(category);
        }
        List categories = this.gm.getGadgetCategory();
        categories.add(0, "all");
        return this.getView(ftlName).arg("gadgets", (Object)gadgetList).arg("categories", (Object)categories).arg("category", (Object)category).arg("mode", (Object)mode);
    }

    @GET
    @Path(value="listGadgets")
    public Object getGadgetList(@QueryParam(value="cat") String category, @QueryParam(value="language") String language) {
        List gadgetList;
        if (language == null) {
            language = "en";
        }
        this.getContext().setLocale(new Locale(language));
        if (category == null) {
            gadgetList = this.gm.getGadgetList();
            category = "all";
        } else {
            gadgetList = this.gm.getGadgetList(category);
        }
        return this.getView("list").arg("gadgets", (Object)gadgetList);
    }

    @GET
    @Path(value="sample")
    public Object getSample() {
        return this.getView("sample-popup");
    }

    @Path(value="{name}")
    public Object getGadget(@PathParam(value="name") String gadgetName) throws Exception {
        if (this.gm == null) {
            return Response.ok((Object)500).build();
        }
        GadgetDeclaration gadget = this.gm.getGadget(gadgetName);
        if (gadget != null) {
            return this.ctx.newObject("gadget", new Object[]{gadget});
        }
        return Response.ok((Object)404).build();
    }

    public String getCategoryLabel(String categoryKey) {
        Locale locale;
        String label;
        if (categoryKey == null) {
            return "";
        }
        if (!categoryKey.startsWith("gadget.category")) {
            categoryKey = "gadget.category." + categoryKey;
        }
        if (categoryKey.equals(label = I18NUtils.getMessageString((String)"messages", (String)categoryKey, null, (Locale)(locale = this.getContext().getLocale())))) {
            label = categoryKey.replace("gadget.category.", "");
            label = org.apache.commons.lang.StringUtils.capitalize((String)label);
        }
        return label;
    }

    @GET
    @Path(value="samplecontainer")
    public Object getSampleContainer() {
        return this.getView("samplecontainer");
    }

    @POST
    @Path(value="securetoken")
    public String getSecureToken(@FormParam(value="gadgetSpecUrls[]") List<String> gadgetSpecUrls) throws Exception {
        CoreSession session = WebEngine.getActiveContext().getCoreSession();
        String principalName = session.getPrincipal().getName();
        ArrayList<String> secureTokens = new ArrayList<String>();
        for (String gadgetSpecUrl : gadgetSpecUrls) {
            secureTokens.add(SecureTokenBuilder.getSecureToken((String)principalName, (String)principalName, (String)gadgetSpecUrl, (boolean)true));
        }
        return StringUtils.join(secureTokens, (String)",");
    }
}

