/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.oauth;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public abstract class DirectoryBasedEditor
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected DocumentModelList entries;
    protected DocumentModel editableEntry;
    protected DocumentModel creationEntry;
    protected boolean showAddForm = false;

    protected abstract String getDirectoryName();

    protected abstract String getSchemaName();

    public boolean getShowAddForm() {
        return this.showAddForm;
    }

    public void toggleShowAddForm() {
        this.showAddForm = !this.showAddForm;
    }

    public DocumentModel getCreationEntry() throws Exception {
        if (this.creationEntry == null) {
            this.creationEntry = BaseSession.createEntryModel(null, (String)this.getSchemaName(), null, null);
        }
        return this.creationEntry;
    }

    public void refresh() {
        this.entries = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEntry() throws Exception {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(this.getDirectoryName());){
            session.createEntry(this.creationEntry);
            this.creationEntry = null;
            this.showAddForm = false;
            this.entries = null;
        }
    }

    public void resetCreateEntry() {
        this.creationEntry = null;
        this.showAddForm = false;
    }

    public void resetEditEntry() {
        this.editableEntry = null;
        this.showAddForm = false;
    }

    public DocumentModel getEditableEntry() {
        return this.editableEntry;
    }

    protected Map<String, Serializable> getQueryFilter() {
        return Collections.emptyMap();
    }

    protected Set<String> getOrderSet() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModelList getEntries() throws Exception {
        if (this.entries == null) {
            DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
            try (Session session = ds.open(this.getDirectoryName());){
                Map<String, Serializable> emptyMap = this.getQueryFilter();
                Set<String> emptySet = this.getOrderSet();
                this.entries = session.query(emptyMap, emptySet, null, true);
            }
        }
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editEntry(String entryId) throws Exception {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(this.getDirectoryName());){
            this.editableEntry = session.getEntry(entryId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveEntry() throws Exception {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(this.getDirectoryName());){
            session.updateEntry(this.editableEntry);
            this.editableEntry = null;
            this.entries = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntry(String entryId) throws Exception {
        DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = ds.open(this.getDirectoryName());){
            session.deleteEntry(entryId);
            if (this.editableEntry != null && this.editableEntry.getId().equals(entryId)) {
                this.editableEntry = null;
            }
            this.entries = null;
        }
    }
}

