/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.runtime;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.nuxeo.ecm.admin.runtime.SimplifiedBundleInfo;
import org.nuxeo.ecm.admin.runtime.SimplifiedServerInfo;
import org.nuxeo.osgi.BundleFile;
import org.nuxeo.osgi.BundleImpl;
import org.nuxeo.osgi.JarBundleFile;
import org.nuxeo.osgi.jboss.JBossBundleFile;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.osgi.framework.Bundle;

public class RuntimeInstrospection {
    protected static SimplifiedServerInfo info;

    public static synchronized SimplifiedServerInfo getInfo() {
        if (info == null) {
            RuntimeService runtime = Framework.getRuntime();
            Collection registrations = runtime.getComponentManager().getRegistrations();
            ArrayList<String> bundleIds = new ArrayList<String>();
            ArrayList<SimplifiedBundleInfo> bundles = new ArrayList<SimplifiedBundleInfo>();
            for (RegistrationInfo ri : registrations) {
                Bundle bundle = ri.getContext().getBundle();
                if (bundle == null || bundleIds.contains(bundle.getSymbolicName())) continue;
                SimplifiedBundleInfo bi = RuntimeInstrospection.getBundleSimplifiedInfo(bundle);
                bundleIds.add(bundle.getSymbolicName());
                if (bi == null) continue;
                bundles.add(bi);
            }
            Collections.sort(bundles);
            info = new SimplifiedServerInfo();
            info.setBundleInfos(bundles);
            info.setRuntimeVersion(runtime.getVersion().toString());
            info.setWarnings(runtime.getWarnings());
        }
        return info;
    }

    protected static SimplifiedBundleInfo getBundleSimplifiedInfo(Bundle bundle) {
        SimplifiedBundleInfo result = null;
        if (bundle instanceof BundleImpl) {
            JarBundleFile jar;
            BundleImpl nxBundle = (BundleImpl)bundle;
            BundleFile file = nxBundle.getBundleFile();
            File jarFile = null;
            if (file instanceof JarBundleFile) {
                jar = (JarBundleFile)file;
                jarFile = jar.getFile();
            } else if (file instanceof JBossBundleFile) {
                jar = (JBossBundleFile)file;
                jarFile = jar.getFile();
            }
            if (jarFile != null && !jarFile.isDirectory()) {
                try {
                    ZipFile zFile = new ZipFile(jarFile);
                    Enumeration<? extends ZipEntry> entries = zFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith("pom.properties")) continue;
                        InputStream pomStream = zFile.getInputStream(entry);
                        PropertyResourceBundle prb = new PropertyResourceBundle(pomStream);
                        String version = prb.getString("version");
                        result = new SimplifiedBundleInfo(bundle.getSymbolicName(), version);
                        pomStream.close();
                        break;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return result;
    }
}

