/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.repo;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.nuxeo.ecm.admin.repo.RepoStatInfo;
import org.nuxeo.ecm.admin.repo.StatsTask;
import org.nuxeo.ecm.core.api.DocumentRef;

public class RepoStat {
    protected ThreadPoolExecutor pool;
    protected int nbThreads = 5;
    protected String repoName;
    protected boolean includeBlob;
    protected RepoStatInfo info;

    public RepoStat(String repoName, int nbThreads, boolean includeBlob) {
        this.nbThreads = nbThreads;
        this.repoName = repoName;
        this.includeBlob = includeBlob;
        this.pool = new ThreadPoolExecutor(nbThreads, nbThreads, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100));
    }

    public void exec(StatsTask task) {
        this.pool.execute(task);
    }

    public void run(DocumentRef root) throws Exception {
        this.info = new RepoStatInfo();
        StatsTask task = new StatsTask(this.repoName, root, this.includeBlob, this);
        this.exec(task);
    }

    protected boolean isPoolFull() {
        return this.pool.getQueue().size() > 1;
    }

    public RepoStatInfo getInfo() {
        return this.info;
    }

    public boolean isRunning() {
        return this.pool.getActiveCount() > 0;
    }
}

