/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin;

import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.ecm.admin.repo.RepoStat;
import org.nuxeo.ecm.admin.repo.RepoStatInfo;
import org.nuxeo.ecm.admin.runtime.RuntimeInstrospection;
import org.nuxeo.ecm.admin.runtime.SimplifiedServerInfo;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.runtime.api.Framework;

@Name(value="systemInfo")
@Scope(value=ScopeType.CONVERSATION)
public class SystemInfoManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String selectedTimeRange;
    protected int currentAuditPage = 1;
    protected static int pageSize = 25;
    protected List<Repository> repositories;
    protected String currentRepositoryName;
    protected RepoStat runningStat;
    protected RepoStatInfo statResult;
    protected static Log log = LogFactory.getLog(SystemInfoManager.class);

    public String getHostInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nOS : ");
        sb.append(System.getProperty("os.name"));
        sb.append(" (");
        sb.append(System.getProperty("os.arch"));
        sb.append(")");
        sb.append("\n");
        sb.append("\nCPU(s) : ");
        sb.append(Runtime.getRuntime().availableProcessors());
        sb.append("\n");
        sb.append("\nJVM : ");
        sb.append(System.getProperty("java.runtime.name"));
        sb.append(" ");
        sb.append(System.getProperty("java.runtime.version"));
        sb.append(" - build ");
        sb.append(System.getProperty("java.vm.version"));
        sb.append(" (");
        sb.append(System.getProperty("java.vendor"));
        sb.append(")");
        sb.append("\n");
        sb.append("\nPlatform language : ");
        sb.append(System.getProperty("user.language"));
        sb.append("  ");
        sb.append(System.getenv("LANG"));
        sb.append("\n");
        sb.append("\nJava Memory:");
        sb.append("\n  Heap size  : ");
        sb.append(Runtime.getRuntime().totalMemory() / 0x100000L);
        sb.append(" MB");
        sb.append("\n  Used       : ");
        sb.append((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L);
        sb.append(" MB");
        sb.append("\n  Free       : ");
        sb.append(Runtime.getRuntime().freeMemory() / 0x100000L);
        sb.append(" MB");
        sb.append("\n  Max size   : ");
        sb.append(Runtime.getRuntime().maxMemory() / 0x100000L);
        sb.append(" MB");
        return sb.toString();
    }

    public String getUptime() {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        long ut = bean.getUptime();
        long uts = ut / 1000L;
        StringBuffer sb = new StringBuffer("Nuxeo Server UpTime : ");
        long nbDays = uts / 86400L;
        if (nbDays > 0L) {
            sb.append(nbDays + " days, ");
            uts %= 86400L;
        }
        long nbHours = uts / 3600L;
        sb.append(nbHours + " h ");
        long nbMin = (uts %= 3600L) / 60L;
        sb.append(nbMin + " m ");
        sb.append((uts %= 60L) + " s  ");
        return sb.toString();
    }

    @Factory(value="nuxeoServerInfo", scope=ScopeType.EVENT)
    public SimplifiedServerInfo getNuxeoServerInfo() {
        return RuntimeInstrospection.getInfo();
    }

    public boolean isMultiRepo() throws Exception {
        return this.listAvailableRepositories().size() > 1;
    }

    public List<Repository> listAvailableRepositories() throws Exception {
        if (this.repositories == null) {
            this.repositories = new ArrayList<Repository>();
            RepositoryManager rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
            Collection repos = rm.getRepositories();
            this.repositories.addAll(repos);
            this.currentRepositoryName = rm.getDefaultRepository().getName();
        }
        return this.repositories;
    }

    public String getCurrentRepositoryName() throws Exception {
        if (this.currentRepositoryName == null) {
            this.listAvailableRepositories();
        }
        return this.currentRepositoryName;
    }

    public void setCurrentRepositoryName(String name) throws Exception {
        this.currentRepositoryName = name;
    }

    public int getOpenSessionNumber() {
        return CoreInstance.getInstance().getSessions().length;
    }

    public void startRepoStats() throws Exception {
        if (this.runningStat != null) {
            return;
        }
        this.statResult = null;
        this.runningStat = new RepoStat(this.getCurrentRepositoryName(), 5, true);
        this.runningStat.run((DocumentRef)new PathRef("/"));
    }

    public void checkReady() {
        this.isStatInfoAvailable();
    }

    public boolean isStatInfoInProgress() {
        if (this.isStatInfoAvailable()) {
            return false;
        }
        return this.runningStat != null;
    }

    public boolean isStatInfoAvailable() {
        if (this.statResult != null) {
            return true;
        }
        if (this.runningStat != null && !this.runningStat.isRunning()) {
            this.statResult = this.runningStat.getInfo();
            Contexts.getEventContext().remove("repoStatResult");
            this.runningStat = null;
            return true;
        }
        return false;
    }

    @Factory(value="repoStatResult", scope=ScopeType.EVENT)
    public RepoStatInfo getStatInfo() {
        return this.statResult;
    }

    public String getRepoUsage() throws Exception {
        StringBuilder sb = new StringBuilder();
        int nbSessions = CoreInstance.getInstance().getSessions().length;
        sb.append("Number of open repository session : ");
        sb.append(nbSessions);
        RepoStat stat = new RepoStat("default", 5, true);
        stat.run((DocumentRef)new PathRef("/"));
        Thread.sleep(100L);
        do {
            Thread.sleep(1000L);
        } while (stat.isRunning());
        sb.append(stat.getInfo().toString());
        return sb.toString();
    }

    public List<SelectItem> getTimeRanges() {
        int i;
        ArrayList<SelectItem> ranges = new ArrayList<SelectItem>();
        for (i = 1; i < 13; ++i) {
            ranges.add(new SelectItem((Object)(i + "h"), "label.timerange." + i + "h"));
        }
        for (i = 1; i < 8; ++i) {
            ranges.add(new SelectItem((Object)(i * 24 + "h"), "label.timerange." + i + "d"));
        }
        for (i = 2; i < 6; ++i) {
            ranges.add(new SelectItem((Object)(168 * i + "h"), "label.timerange." + i + "w"));
        }
        return ranges;
    }

    public String getSelectedTimeRange() {
        if (this.selectedTimeRange == null) {
            this.selectedTimeRange = "1h";
        }
        return this.selectedTimeRange;
    }

    public void setSelectedTimeRange(String dateRange) {
        this.selectedTimeRange = dateRange;
        this.currentAuditPage = 1;
        Contexts.getEventContext().remove("userLoginEvents");
    }

    public int getCurrentAuditPage() {
        return this.currentAuditPage;
    }

    public void nextPage() {
        ++this.currentAuditPage;
        Contexts.getEventContext().remove("userLoginEvents");
    }

    public void prevPage() {
        --this.currentAuditPage;
        if (this.currentAuditPage <= 0) {
            this.currentAuditPage = 1;
        }
        Contexts.getEventContext().remove("userLoginEvents");
    }

    @Factory(value="userLoginEvents", scope=ScopeType.EVENT)
    public List<LogEntry> getLoginInfo() throws Exception {
        String[] events = new String[]{"loginSuccess", "loginFailed", "logout"};
        AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
        return reader.queryLogsByPage(events, this.selectedTimeRange, "NuxeoAuthentication", null, this.currentAuditPage, pageSize);
    }

    public String restartServer() {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)true);
        String restartUrl = BaseURL.getBaseURL((ServletRequest)request);
        restartUrl = restartUrl + "site/connectClient/restartView";
        try {
            context.getExternalContext().redirect(restartUrl);
        }
        catch (IOException e) {
            log.error((Object)"Error while redirecting to restart page", (Throwable)e);
        }
        return null;
    }
}

