/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.log4j.ThreadedStreamGobbler;
import org.nuxeo.runtime.api.Framework;

public class NuxeoCtlManager {
    protected static final String CMD_POSIX = "nuxeoctl";
    protected static final String CMD_WIN = "nuxeoctl.bat";
    protected static final Log log = LogFactory.getLog(NuxeoCtlManager.class);
    private static boolean restartInProgress = false;

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().contains("windows");
    }

    protected static boolean doExec(String path) {
        Process p1;
        String[] cmd;
        if (NuxeoCtlManager.isWindows()) {
            cmd = new String[]{"cmd", "/C", new File(path, CMD_WIN).getPath(), "nogui", "restartbg"};
            log.debug((Object)("Restart command: " + cmd[0] + " " + cmd[1] + " " + cmd[2] + " " + cmd[3] + " " + cmd[4]));
        } else {
            cmd = new String[]{"/bin/sh", "-c", new File(path, CMD_POSIX).getPath() + " restartbg"};
            log.debug((Object)("Restart command: " + cmd[0] + " " + cmd[1] + " " + cmd[2]));
        }
        try {
            p1 = Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            log.error((Object)"Unable to restart server", (Throwable)e);
            return false;
        }
        new ThreadedStreamGobbler(p1.getInputStream(), 7).start();
        new ThreadedStreamGobbler(p1.getErrorStream(), 5).start();
        return true;
    }

    public static synchronized boolean restart() {
        if (restartInProgress) {
            return false;
        }
        restartInProgress = true;
        String nuxeoHome = Framework.getProperty((String)"nuxeo.home");
        final String binPath = new File(nuxeoHome, "bin").getPath();
        new Thread("restart thread"){

            @Override
            public void run() {
                try {
                    log.info((Object)"Restarting Nuxeo server");
                    Thread.sleep(3000L);
                    NuxeoCtlManager.doExec(binPath);
                }
                catch (InterruptedException e) {
                    log.error((Object)"Restart failed", (Throwable)e);
                }
            }
        }.start();
        return true;
    }

    public String restartServer() {
        NuxeoCtlManager.restart();
        return "Nuxeo server is restarting";
    }
}

