/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.log4j.ThreadedStreamGobbler;
import org.nuxeo.runtime.api.Framework;

public class NuxeoCtlManager {
    protected static final String CMD_POSIX = "nuxeoctl";
    protected static final String CMD_WIN = "nuxeoctl.bat";
    protected static final Log log = LogFactory.getLog(NuxeoCtlManager.class);
    private static boolean restartInProgress = false;

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().contains("windows");
    }

    private static String winEscape(String command) {
        return command.replaceAll("([ ()<>&])", "^$1");
    }

    protected static boolean doExec(String path, String logPath) {
        Process p1;
        Object[] cmd = NuxeoCtlManager.isWindows() ? new String[]{"cmd", "/C", NuxeoCtlManager.winEscape(new File(path, CMD_WIN).getPath()), "nogui", "restartbg"} : new String[]{"/bin/sh", "-c", "\"" + new File(path, CMD_POSIX).getPath() + "\"" + " restartbg"};
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Restart command: " + StringUtils.join((Object[])cmd, (String)" ")));
            }
            p1 = Runtime.getRuntime().exec((String[])cmd);
        }
        catch (IOException e) {
            log.error((Object)"Unable to restart server", (Throwable)e);
            return false;
        }
        if (NuxeoCtlManager.isWindows()) {
            File logPathDir = new File(logPath);
            File out = new File(logPathDir, "restart-" + System.currentTimeMillis() + ".log");
            File err = new File(logPathDir, "restart-err-" + System.currentTimeMillis() + ".log");
            FileOutputStream fout = null;
            FileOutputStream ferr = null;
            try {
                fout = new FileOutputStream(out);
                ferr = new FileOutputStream(err);
            }
            catch (Exception e) {
                // empty catch block
            }
            new ThreadedStreamGobbler(p1.getInputStream(), (OutputStream)fout).start();
            new ThreadedStreamGobbler(p1.getErrorStream(), (OutputStream)ferr).start();
        } else {
            new ThreadedStreamGobbler(p1.getInputStream(), 7).start();
            new ThreadedStreamGobbler(p1.getErrorStream(), 5).start();
        }
        return true;
    }

    public static synchronized boolean restart() {
        if (restartInProgress) {
            return false;
        }
        restartInProgress = true;
        String nuxeoHome = Framework.getProperty((String)"nuxeo.home");
        final String binPath = new File(nuxeoHome, "bin").getPath();
        final String logDir = Framework.getProperty((String)"nuxeo.log.dir", (String)nuxeoHome);
        new Thread("restart thread"){

            @Override
            public void run() {
                try {
                    log.info((Object)"Restarting Nuxeo server");
                    Thread.sleep(3000L);
                    NuxeoCtlManager.doExec(binPath, logDir);
                }
                catch (InterruptedException e) {
                    log.error((Object)"Restart failed", (Throwable)e);
                }
            }
        }.start();
        return true;
    }

    public String restartServer() {
        NuxeoCtlManager.restart();
        return "Nuxeo server is restarting";
    }
}

