/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.vindoz;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.runtime.api.Framework;

public class InstallAfterRestart {
    public static final String FILE_NAME = "installAfterRestart.log";
    public static final String FAKE_VIDOZ = "org.nuxeo.fake.vindoz";
    protected static final List<String> pkgNameOrIds = new ArrayList<String>();
    protected static final List<String> uninstallpkgNameOrIds = new ArrayList<String>();
    protected static final Log log = LogFactory.getLog(InstallAfterRestart.class);

    protected static boolean isNeededByOs() {
        if ("true".equals(Framework.getProperty((String)FAKE_VIDOZ, (String)"false"))) {
            return true;
        }
        return InstallAfterRestart.isVindozBox();
    }

    public static boolean isNeededForPackage(Package pkg) {
        if (!Framework.isDevModeSet()) {
            return true;
        }
        boolean isNotStudioOrWindows = PackageType.STUDIO != pkg.getType() && InstallAfterRestart.isNeededByOs();
        boolean isHotFix = PackageType.HOT_FIX == pkg.getType();
        boolean isAddonAndNoHotReload = PackageType.ADDON == pkg.getType() && !pkg.supportsHotReload();
        return isNotStudioOrWindows || isHotFix || isAddonAndNoHotReload;
    }

    protected static boolean isDevMode() {
        String debugPropValue = Framework.getProperty((String)"org.nuxeo.dev", (String)"false");
        return Boolean.TRUE.equals(Boolean.valueOf(debugPropValue));
    }

    protected static boolean isVindozBox() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    }

    public static void addPackageForInstallation(String pkgNameOrId) {
        if (!pkgNameOrIds.contains(pkgNameOrId)) {
            pkgNameOrIds.add(pkgNameOrId);
            InstallAfterRestart.savePkgList();
        }
    }

    public static void addPackageForUnInstallation(String pkgNameOrId) {
        if (!pkgNameOrIds.contains(pkgNameOrId) && !uninstallpkgNameOrIds.contains(pkgNameOrId)) {
            pkgNameOrIds.add(pkgNameOrId);
            uninstallpkgNameOrIds.add(pkgNameOrId);
            InstallAfterRestart.savePkgList();
        }
    }

    public static boolean isMarkedForInstallAfterRestart(String pkgNameOrId) {
        return pkgNameOrIds.contains(pkgNameOrId);
    }

    protected static void savePkgList() {
        String path = Framework.getProperty((String)"nuxeo.data.dir");
        File installFile = new File(path, FILE_NAME);
        ArrayList<String> cmds = new ArrayList<String>();
        Iterator<String> i$ = pkgNameOrIds.iterator();
        while (i$.hasNext()) {
            String pkgNameOrId;
            String cmd = pkgNameOrId = i$.next();
            if (uninstallpkgNameOrIds.contains(pkgNameOrId)) {
                cmd = "uninstall " + pkgNameOrId;
            }
            cmds.add(cmd);
        }
        try {
            FileUtils.writeLines((File)installFile, cmds);
        }
        catch (IOException e) {
            log.error((Object)"Unable to same listing of packages to install on restart", (Throwable)e);
        }
    }

    public static boolean isMarkedForUninstallAfterRestart(String pkgName) {
        return uninstallpkgNameOrIds.contains(pkgName);
    }
}

