/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.client.we;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.connect.client.status.ConnectStatusHolder;
import org.nuxeo.connect.client.ui.SharedPackageListingsSettings;
import org.nuxeo.connect.client.vindoz.InstallAfterRestart;
import org.nuxeo.connect.client.we.StudioSnapshotHelper;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.data.SubscriptionStatusType;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageVisibility;
import org.nuxeo.ecm.admin.runtime.PlatformVersionHelper;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="packageListingProvider")
public class PackageListingProvider
extends DefaultObject {
    @Deprecated
    public String getConnectBaseUrl() {
        return ConnectUrlConfig.getBaseUrl();
    }

    @Deprecated
    protected List<DownloadablePackage> filterOnPlatform(List<DownloadablePackage> pkgs, Boolean filterOnPlatform) {
        if (filterOnPlatform != Boolean.TRUE) {
            return pkgs;
        }
        String targetPF = PlatformVersionHelper.getPlatformFilter();
        if (targetPF == null) {
            return pkgs;
        }
        ArrayList<DownloadablePackage> filteredPackages = new ArrayList<DownloadablePackage>();
        for (DownloadablePackage pkg : pkgs) {
            if (!PlatformVersionHelper.isCompatible(pkg.getTargetPlatforms())) continue;
            filteredPackages.add(pkg);
        }
        return filteredPackages;
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="list")
    public Object doList(@QueryParam(value="type") String pkgType, @QueryParam(value="filterOnPlatform") Boolean filterOnPlatform) {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        String targetPlatform = this.getTargetPlatform(filterOnPlatform);
        List pkgs = StringUtils.isBlank((String)pkgType) ? pm.listPackages(targetPlatform) : pm.listPackages(PackageType.getByValue((String)pkgType), targetPlatform);
        return this.getView("simpleListing").arg("pkgs", (Object)pm.sort(pkgs)).arg("showCommunityInfo", (Object)true).arg("source", (Object)"list").arg("filterOnPlatform", (Object)filterOnPlatform);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="updates")
    public Object getUpdates(@QueryParam(value="type") String pkgType, @QueryParam(value="filterOnPlatform") Boolean filterOnPlatform) {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        if (pkgType == null) {
            pkgType = SharedPackageListingsSettings.instance().get("updates").getPackageTypeFilter();
        }
        if (filterOnPlatform == null) {
            filterOnPlatform = SharedPackageListingsSettings.instance().get("updates").getPlatformFilter();
        }
        String targetPlatform = this.getTargetPlatform(filterOnPlatform);
        List pkgs = StringUtils.isBlank((String)pkgType) ? pm.listUpdatePackages(null, targetPlatform) : pm.listUpdatePackages(PackageType.getByValue((String)pkgType), targetPlatform);
        return this.getView("simpleListing").arg("pkgs", (Object)pm.sort(pkgs)).arg("showCommunityInfo", (Object)true).arg("source", (Object)"updates").arg("filterOnPlatform", (Object)filterOnPlatform);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="private")
    public Object getPrivate(@QueryParam(value="type") String pkgType, @QueryParam(value="filterOnPlatform") Boolean filterOnPlatform) {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        if (pkgType == null) {
            pkgType = SharedPackageListingsSettings.instance().get("private").getPackageTypeFilter();
        }
        if (filterOnPlatform == null) {
            filterOnPlatform = SharedPackageListingsSettings.instance().get("private").getPlatformFilter();
        }
        String targetPlatform = this.getTargetPlatform(filterOnPlatform);
        List pkgs = StringUtils.isBlank((String)pkgType) ? pm.listPrivatePackages(targetPlatform) : pm.listPrivatePackages(PackageType.getByValue((String)pkgType), targetPlatform);
        return this.getView("simpleListing").arg("pkgs", (Object)pm.sort(pkgs)).arg("showCommunityInfo", (Object)true).arg("source", (Object)"private").arg("filterOnPlatform", (Object)filterOnPlatform);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="local")
    public Object getLocal(@QueryParam(value="type") String pkgType) {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        if (pkgType == null) {
            pkgType = SharedPackageListingsSettings.instance().get("local").getPackageTypeFilter();
        }
        List pkgs = StringUtils.isBlank((String)pkgType) ? pm.listLocalPackages() : pm.listLocalPackages(PackageType.getByValue((String)pkgType));
        return this.getView("simpleListing").arg("pkgs", (Object)pm.sort(pkgs)).arg("showCommunityInfo", (Object)false).arg("source", (Object)"local");
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="remote")
    public Object getRemote(@QueryParam(value="type") String pkgType, @QueryParam(value="onlyRemote") Boolean onlyRemote, @QueryParam(value="searchString") String searchString, @QueryParam(value="filterOnPlatform") Boolean filterOnPlatform) {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        if (pkgType == null) {
            pkgType = SharedPackageListingsSettings.instance().get("remote").getPackageTypeFilter();
        }
        if (filterOnPlatform == null) {
            filterOnPlatform = SharedPackageListingsSettings.instance().get("remote").getPlatformFilter();
        }
        if (onlyRemote == null) {
            onlyRemote = SharedPackageListingsSettings.instance().get("remote").isOnlyRemote();
        }
        String targetPlatform = this.getTargetPlatform(filterOnPlatform);
        List pkgs = !StringUtils.isEmpty((String)searchString) ? pm.searchPackages(searchString) : (onlyRemote.booleanValue() ? (StringUtils.isBlank((String)pkgType) ? pm.listOnlyRemotePackages(targetPlatform) : pm.listOnlyRemotePackages(PackageType.getByValue((String)pkgType), targetPlatform)) : (StringUtils.isBlank((String)pkgType) ? pm.listRemoteOrLocalPackages(targetPlatform) : pm.listRemoteOrLocalPackages(PackageType.getByValue((String)pkgType), targetPlatform)));
        return this.getView("simpleListing").arg("pkgs", (Object)pm.sort(pkgs)).arg("showCommunityInfo", (Object)false).arg("source", (Object)"remote").arg("filterOnPlatform", (Object)filterOnPlatform);
    }

    private String getTargetPlatform(Boolean filterOnPlatform) {
        if (filterOnPlatform != Boolean.TRUE) {
            return null;
        }
        return PlatformVersionHelper.getPlatformFilter();
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="studio")
    public Object getStudio() {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        List pkgs = pm.listAllStudioRemoteOrLocalPackages();
        List<DownloadablePackage> pkgsWithoutSnapshot = StudioSnapshotHelper.removeSnapshot(pkgs);
        return this.getView("simpleListing").arg("pkgs", (Object)pm.sort(pkgsWithoutSnapshot)).arg("showCommunityInfo", (Object)false).arg("source", (Object)"studio");
    }

    public String getStateLabel(Package pkg) {
        switch (pkg.getState()) {
            case 0: {
                return "remote";
            }
            case 2: {
                return "downloaded";
            }
            case 1: {
                DownloadingPackage dpkg = (DownloadingPackage)pkg;
                return "downloading (" + dpkg.getDownloadProgress() + "%)";
            }
            case 3: {
                return "installation in progress";
            }
            case 4: {
                return "installed";
            }
            case 5: {
                return "running";
            }
        }
        return "!?!";
    }

    public boolean canInstall(Package pkg) {
        return 2 == pkg.getState() && !InstallAfterRestart.isMarkedForInstallAfterRestart(pkg.getId());
    }

    public boolean needsRestart(Package pkg) {
        return InstallAfterRestart.isMarkedForInstallAfterRestart(pkg.getId()) || 4 == pkg.getState() || InstallAfterRestart.isMarkedForUninstallAfterRestart(pkg.getName());
    }

    public boolean canUnInstall(Package pkg) {
        return (4 == pkg.getState() || 5 == pkg.getState()) && !InstallAfterRestart.isMarkedForUninstallAfterRestart(pkg.getName());
    }

    public boolean canRemove(Package pkg) {
        return pkg.isLocal();
    }

    public boolean canCancel(Package pkg) {
        return 1 == pkg.getState();
    }

    public boolean canDownload(Package pkg) {
        return pkg.getState() == 0 && (pkg.getType() == PackageType.STUDIO || pkg.getVisibility() == PackageVisibility.PUBLIC || ConnectStatusHolder.instance().isRegistred() && ConnectStatusHolder.instance().getStatus().status() == SubscriptionStatusType.OK);
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="details/{pkgId}")
    public Object getDetails(@PathParam(value="pkgId") String pkgId) {
        PackageManager pm = (PackageManager)Framework.getLocalService(PackageManager.class);
        DownloadablePackage pkg = pm.getPackage(pkgId);
        if (pkg != null) {
            return this.getView("pkgDetails").arg("pkg", (Object)pkg);
        }
        return this.getView("pkgNotFound").arg("pkgId", (Object)pkgId);
    }

    public boolean registrationRequired(Package pkg) {
        return pkg.getState() == 0 && pkg.getType() != PackageType.STUDIO && pkg.getVisibility() != PackageVisibility.PUBLIC && (!ConnectStatusHolder.instance().isRegistred() || ConnectStatusHolder.instance().getStatus().status() != SubscriptionStatusType.OK);
    }
}

