/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin;

import java.io.Serializable;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.TabActionsSelection;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="adminViews")
@Scope(value=ScopeType.CONVERSATION)
public class AdminViewManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String externalPackageDownloadRequest;
    public static final String ADMIN_ACTION_CATEGORY = "NUXEO_ADMIN";
    public static final String VIEW_ADMIN = "view_admin";
    @In(create=true, required=false)
    protected WebActions webActions;
    @In(create=true, required=false)
    protected transient NavigationContext navigationContext;
    protected DocumentModel lastVisitedDocument;

    public String goHome() {
        this.webActions.resetCurrentTabs(ADMIN_ACTION_CATEGORY);
        Contexts.getEventContext().remove("currentView");
        Contexts.getEventContext().remove("currentAdminSubView");
        return VIEW_ADMIN;
    }

    public String enter() {
        this.lastVisitedDocument = this.navigationContext.getCurrentDocument();
        return VIEW_ADMIN;
    }

    public String exit() throws ClientException {
        if (this.lastVisitedDocument != null) {
            return this.navigationContext.navigateToDocument(this.lastVisitedDocument);
        }
        return this.navigationContext.goHome();
    }

    @Factory(value="currentAdminView", scope=ScopeType.EVENT)
    public Action getCurrentView() {
        return this.webActions.getCurrentTabAction(ADMIN_ACTION_CATEGORY);
    }

    public void setCurrentView(Action currentView) {
        this.webActions.setCurrentTabAction(ADMIN_ACTION_CATEGORY, currentView);
    }

    public String getCurrentViewId() {
        return this.getCurrentView().getId();
    }

    public String setCurrentViewId(String currentViewId) {
        this.webActions.setCurrentTabId(ADMIN_ACTION_CATEGORY, currentViewId, new String[0]);
        return VIEW_ADMIN;
    }

    @Factory(value="currentAdminSubView", scope=ScopeType.EVENT)
    public Action getCurrentSubView() {
        return this.webActions.getCurrentSubTabAction(this.getCurrentViewId());
    }

    public void setCurrentSubView(Action currentSubView) {
        this.webActions.setCurrentTabAction(TabActionsSelection.getSubTabCategory((String)this.getCurrentViewId()), currentSubView);
    }

    @Factory(value="currentAdminSubViewId", scope=ScopeType.EVENT)
    public String getCurrentSubViewId() {
        return this.getCurrentSubView().getId();
    }

    public void setCurrentSubViewId(String currentSubViewId) {
        this.webActions.setCurrentTabId(TabActionsSelection.getSubTabCategory((String)this.getCurrentViewId()), currentSubViewId, new String[0]);
    }

    public List<Action> getAvailableActions() {
        return this.webActions.getActionsList(ADMIN_ACTION_CATEGORY);
    }

    public List<Action> getAvailableSubActions() {
        return this.webActions.getActionsList(TabActionsSelection.getSubTabCategory((String)this.getCurrentViewId()));
    }

    public boolean hasExternalPackageDownloadRequest() {
        return this.externalPackageDownloadRequest != null;
    }

    public void addExternalPackageDownloadRequest(String pkgId) {
        this.externalPackageDownloadRequest = pkgId;
    }

    public String getExternalPackageDownloadRequest() {
        String id = this.externalPackageDownloadRequest;
        this.externalPackageDownloadRequest = null;
        return id;
    }

    public boolean isUpdateCenterDisabled() {
        return Framework.isBooleanPropertyTrue((String)"nuxeo.updatecenter.disabled");
    }

    public boolean isProductionServer() {
        return Framework.isBooleanPropertyTrue((String)"org.nuxeo.prod");
    }
}

