/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.classification;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelComparator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

public class PagedClassificationsProvider
implements PagedDocumentsProvider {
    private static final long serialVersionUID = 1L;
    protected final List<DocumentModel> documents;
    protected final int pageSize;
    protected int currentPageIndex = 0;
    protected final SortInfo sortInfo;
    protected String name;

    public PagedClassificationsProvider(List<DocumentModel> documents, int pageSize, String name, SortInfo sortInfo) {
        this.pageSize = pageSize;
        this.name = name;
        this.sortInfo = sortInfo;
        if (documents == null) {
            documents = new DocumentModelListImpl();
        }
        if (sortInfo != null) {
            HashMap<String, String> sort = new HashMap<String, String>();
            sort.put(sortInfo.getSortColumn(), sortInfo.getSortAscending() ? "asc" : "");
            Collections.sort(documents, new DocumentModelComparator(sort));
        }
        this.documents = documents;
    }

    public DocumentModelList getCurrentPage() {
        return this.getPage(this.currentPageIndex);
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public int getCurrentPageOffset() {
        return this.currentPageIndex * this.pageSize;
    }

    public int getCurrentPageSize() {
        return this.getCurrentPage().size();
    }

    public String getCurrentPageStatus() {
        int total = this.getNumberOfPages();
        int current = this.currentPageIndex + 1;
        if (total == -1) {
            return String.format("%d", current);
        }
        return String.format("%d/%d", current, total);
    }

    public String getName() {
        return this.name;
    }

    protected void setCurrentPageIndex(int index) {
        this.currentPageIndex = index;
    }

    public DocumentModelList getNextPage() {
        this.setCurrentPageIndex(this.currentPageIndex + 1);
        return this.getCurrentPage();
    }

    public int getNumberOfPages() {
        long size = this.documents.size();
        if (size == -1L) {
            return -1;
        }
        return (int)(1L + (size - 1L) / (long)this.pageSize);
    }

    public DocumentModelList getPage(int page) {
        int fromIndex = this.currentPageIndex * this.pageSize;
        int toIndex = fromIndex + this.pageSize;
        int size = this.documents.size();
        if (toIndex > size) {
            toIndex = size;
        }
        DocumentModelListImpl docsPage = new DocumentModelListImpl();
        docsPage.addAll(this.documents.subList(fromIndex, toIndex));
        return docsPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getResultsCount() {
        return this.documents.size();
    }

    public SortInfo getSortInfo() {
        return this.sortInfo;
    }

    public boolean isNextPageAvailable() {
        return this.currentPageIndex < this.getNumberOfPages() - 1;
    }

    public boolean isPreviousPageAvailable() {
        return this.currentPageIndex > 0;
    }

    public boolean isSortable() {
        return true;
    }

    public void last() {
        int lastPage = this.getNumberOfPages();
        if (lastPage == -1) {
            while (this.isNextPageAvailable()) {
                this.getNextPage();
            }
        } else {
            this.setCurrentPageIndex(lastPage - 1);
        }
    }

    public void next() {
        this.setCurrentPageIndex(this.currentPageIndex + 1);
    }

    public void previous() {
        if (this.currentPageIndex > 0) {
            this.setCurrentPageIndex(this.currentPageIndex - 1);
        }
    }

    public void refresh() {
    }

    public void rewind() {
        this.setCurrentPageIndex(0);
    }

    public void setName(String name) {
        this.name = name;
    }
}

