/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.offline.update;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.connect.update.AlreadyExistsPackageException;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.osgi.application.loader.FrameworkLoader;
import org.nuxeo.runtime.api.Framework;

public class LocalPackageManager {
    static final Log log = LogFactory.getLog(LocalPackageManager.class);
    protected File home;
    protected File wd;
    protected File bundlesDir;
    protected List<File> bundles;
    protected File config;
    protected Map<String, Object> env;
    protected Environment targetEnv;
    protected List<String> packages = new ArrayList<String>();
    protected PackageUpdateService pus;
    private String command;
    private int errorValue = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        LocalPackageManager main = null;
        try {
            main = new LocalPackageManager(args);
            main.initializeFramework();
            main.startFramework();
            main.run(args);
        }
        catch (Throwable e) {
            log.error((Object)e);
            main.errorValue = 2;
        }
        finally {
            if (main != null) {
                main.stopFramework();
            }
        }
        System.exit(main.errorValue);
    }

    public LocalPackageManager(String[] args) throws FileNotFoundException {
        if (args.length < 3) {
            this.printHelp();
            System.exit(1);
        }
        this.wd = new File(args[0]);
        if (!this.wd.isDirectory()) {
            throw new IllegalStateException(this.wd + " is not a directory!");
        }
        this.command = args[1];
        this.config = new File(args[2]);
        if (args.length < 4 && Arrays.asList("installpkg", "uninstall", "add", "remove").contains(this.command)) {
            log.error((Object)"Missing parameter");
            this.printHelp();
            System.exit(1);
        }
        this.home = new File(System.getProperty("nuxeo.runtime.home"));
        if (this.home == null) {
            throw new IllegalStateException("Syntax Error: You must provide the runtime home as a System property (\"nuxeo.runtime.home\").");
        }
        this.bundlesDir = new File(this.wd, "bundles");
        this.initBundleFiles();
        this.initEnvironment();
        this.targetEnv = this.createTargetEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        block17: {
            Environment defaultEnv = Environment.getDefault();
            try {
                Environment.setDefault((Environment)this.targetEnv);
                if ("install".equalsIgnoreCase(this.command)) {
                    this.readPackages();
                    this.update();
                    break block17;
                }
                if ("installpkg".equalsIgnoreCase(this.command)) {
                    for (String packageParam : Arrays.copyOfRange(args, 3, args.length)) {
                        if (new File(packageParam).exists()) {
                            this.update(packageParam);
                            continue;
                        }
                        this.updatePackage(packageParam);
                    }
                    break block17;
                }
                if ("uninstall".equalsIgnoreCase(this.command)) {
                    for (String packageParam : Arrays.copyOfRange(args, 3, args.length)) {
                        this.uninstall(packageParam);
                    }
                    break block17;
                }
                if ("add".equalsIgnoreCase(this.command)) {
                    for (String packageParam : Arrays.copyOfRange(args, 3, args.length)) {
                        this.add(packageParam);
                    }
                    break block17;
                }
                if ("remove".equalsIgnoreCase(this.command)) {
                    for (String packageParam : Arrays.copyOfRange(args, 3, args.length)) {
                        this.remove(packageParam);
                    }
                    break block17;
                }
                if ("list".equalsIgnoreCase(this.command)) {
                    this.readPackages();
                    this.listPackages();
                    break block17;
                }
                if ("reset".equalsIgnoreCase(this.command)) {
                    this.reset();
                    break block17;
                }
                this.printHelp();
                return;
            }
            catch (PackageException e) {
                log.error((Object)e);
                this.errorValue = 1;
            }
            finally {
                Environment.setDefault((Environment)defaultEnv);
            }
        }
    }

    public void printHelp() {
        log.error((Object)"\nLocalPackageManager usage: working_directory command [parameters]");
        log.error((Object)"Commands:");
        log.error((Object)"\tlist\t\t\t\t\t\tList local packages and their status.");
        log.error((Object)"\tadd </path/to/package>...\t\t\tAdd the given package(s) into the local cache.");
        log.error((Object)"\tinstall </path/to/package>...\t\t\tInstall the given package(s).");
        log.error((Object)"\tinstallpkg </path/to/package|packageId>...\tInstall the given package(s) (as a file or its ID).");
        log.error((Object)"\tuninstall packageId...\t\t\t\tUninstall the specified package(s).");
        log.error((Object)"\tremove packageId...\t\t\t\tRemove the specified package(s).");
        log.error((Object)"\treset\t\t\t\t\t\tReset all package states to DOWNLOADED. This may be useful after a manual upgrade of the server.");
    }

    protected void initEnvironment() {
        this.env = new HashMap<String, Object>();
    }

    protected Environment createTargetEnvironment() {
        Environment environment = new Environment(this.home);
        environment.init();
        return environment;
    }

    protected void initBundleFiles() throws FileNotFoundException {
        this.bundles = new ArrayList<File>();
        if (!this.bundlesDir.isDirectory()) {
            throw new FileNotFoundException("File " + this.bundlesDir + " is not a directory");
        }
        File[] list = this.bundlesDir.listFiles();
        if (list == null) {
            throw new FileNotFoundException("No bundles found in " + this.bundlesDir);
        }
        for (File file : list) {
            String name = file.getName();
            if (!name.endsWith(".jar") || !name.contains("nuxeo-") || name.contains("osgi")) continue;
            this.bundles.add(file);
        }
    }

    public void initializeFramework() {
        System.setProperty("org.nuxeo.connect.update.dataDir", this.targetEnv.getData().getAbsolutePath());
        FrameworkLoader.initialize((ClassLoader)LocalPackageManager.class.getClassLoader(), (File)this.wd, this.bundles, this.env);
    }

    public void startFramework() throws Exception {
        FrameworkLoader.start();
        this.pus = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
        if (this.pus == null) {
            throw new IllegalStateException("PackagUpdateService not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFramework() throws Exception {
        try {
            FrameworkLoader.stop();
        }
        finally {
            if (this.wd != null) {
                FileUtils.deleteTree((File)this.wd);
            }
        }
    }

    public void update() throws PackageException {
        if (this.packages.isEmpty()) {
            return;
        }
        log.info((Object)"Performing update ...");
        for (String pkgId : this.packages) {
            try {
                String cmd = "install";
                if (pkgId.startsWith("uninstall ")) {
                    pkgId = pkgId.substring(10);
                    cmd = "uninstall";
                } else if (pkgId.startsWith("install ")) {
                    pkgId = pkgId.substring(8);
                    cmd = "install";
                } else if (pkgId.startsWith("add ")) {
                    pkgId = pkgId.substring(4);
                    cmd = "add";
                }
                if (pkgId.startsWith("file:")) {
                    String packageFileName = pkgId.substring(5);
                    log.info((Object)("Getting Installation package " + packageFileName));
                    LocalPackage pkg = this.pus.addPackage(new File(packageFileName));
                    pkgId = pkg.getId();
                }
                if ("uninstall".equals(cmd)) {
                    this.uninstall(pkgId);
                    continue;
                }
                if (!"install".equals(cmd)) continue;
                this.updatePackage(pkgId);
            }
            catch (AlreadyExistsPackageException e) {
                log.warn((Object)e);
            }
            catch (PackageException e) {
                log.error((Object)e);
                this.errorValue = 1;
            }
        }
        if (this.errorValue != 0) {
            File bak = new File(this.config.getPath() + ".bak");
            bak.delete();
            this.config.renameTo(bak);
            throw new PackageException("An error occurred. File renamed to " + bak);
        }
        log.info((Object)"Done.");
        this.config.delete();
    }

    protected void readPackages() {
        if (!this.config.isFile()) {
            log.debug((Object)("No file " + this.config));
            return;
        }
        try {
            List lines = FileUtils.readLines((File)this.config);
            for (String line : lines) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                this.packages.add(line);
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
    }

    public void update(String packageFileName) throws PackageException {
        LocalPackage pkg = this.pus.addPackage(new File(packageFileName));
        String pkgId = pkg.getId();
        this.updatePackage(pkgId);
    }

    protected void updatePackage(String pkgId) throws PackageException {
        LocalPackage pkg = this.pus.getPackage(pkgId);
        if (pkg == null) {
            throw new IllegalStateException("No package found: " + pkgId);
        }
        log.info((Object)("Updating " + pkgId));
        Task installTask = pkg.getInstallTask();
        try {
            this.performTask(installTask);
        }
        catch (Throwable e) {
            installTask.rollback();
            this.errorValue = 1;
            log.error((Object)("Failed to install package: " + pkgId), e);
        }
    }

    public void performTask(Task task) throws PackageException {
        ValidationStatus status = task.validate();
        if (status.hasErrors()) {
            this.errorValue = 3;
            throw new PackageException("Failed to validate package " + task.getPackage().getId() + " -> " + status.getErrors());
        }
        if (status.hasWarnings()) {
            log.warn((Object)("Got warnings on package validation " + task.getPackage().getId() + " -> " + status.getWarnings()));
        }
        task.run(null);
    }

    private void uninstall(String pkgId) throws PackageException {
        LocalPackage pkg = this.pus.getPackage(pkgId);
        if (pkg == null) {
            throw new IllegalStateException("No package found: " + pkgId);
        }
        log.info((Object)("Uninstalling " + pkgId));
        Task uninstallTask = pkg.getUninstallTask();
        try {
            this.performTask(uninstallTask);
        }
        catch (Throwable e) {
            uninstallTask.rollback();
            this.errorValue = 1;
            log.error((Object)("Failed to uninstall package: " + pkgId), e);
        }
    }

    private void add(String packageFileName) throws PackageException {
        log.info((Object)("Adding " + packageFileName));
        try {
            this.pus.addPackage(new File(packageFileName));
        }
        catch (Throwable e) {
            log.error((Object)("Failed to add package: " + packageFileName), e);
        }
    }

    private void remove(String pkgId) throws PackageException {
        LocalPackage pkg = this.pus.getPackage(pkgId);
        if (pkg == null) {
            throw new IllegalStateException("No package found: " + pkgId);
        }
        if (pkg.getState() != 2) {
            throw new IllegalStateException("Can only remove packages in DOWNLOADED state");
        }
        log.info((Object)("Removing " + pkgId));
        try {
            this.pus.removePackage(pkgId);
        }
        catch (Throwable e) {
            log.error((Object)("Failed to remove package: " + pkgId), e);
        }
    }

    private void listPackages() throws PackageException {
        if (this.packages.isEmpty()) {
            log.info((Object)"No package waiting for install.");
        } else {
            log.info((Object)"Waiting for install:");
            for (String pkg : this.packages) {
                log.info((Object)pkg);
            }
        }
        List localPackages = this.pus.getPackages();
        if (localPackages.isEmpty()) {
            log.info((Object)"No local package.");
        } else {
            log.info((Object)"Local packages:");
            for (LocalPackage localPackage : localPackages) {
                String packageDescription;
                switch (localPackage.getState()) {
                    case 1: {
                        packageDescription = "downloading...";
                        break;
                    }
                    case 2: {
                        packageDescription = "downloaded";
                        break;
                    }
                    case 3: {
                        packageDescription = "installing...";
                        break;
                    }
                    case 4: {
                        packageDescription = "installed";
                        break;
                    }
                    case 5: {
                        packageDescription = "started";
                        break;
                    }
                    default: {
                        packageDescription = "unknown";
                    }
                }
                packageDescription = packageDescription + "\t" + localPackage.getName() + " (id: " + localPackage.getId() + ")";
                log.info((Object)packageDescription);
            }
        }
    }

    private void reset() throws PackageException {
        this.pus.reset();
        log.info((Object)"Packages reset done: All packages were marked as DOWNLOADED");
    }
}

