/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task.commands;

import java.io.File;
import java.util.Map;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateComponent;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.impl.task.AbstractCommand;
import org.nuxeo.connect.update.impl.task.Command;
import org.nuxeo.connect.update.impl.task.commands.Uninstall;
import org.nuxeo.connect.update.impl.xml.XmlWriter;
import org.nuxeo.connect.update.task.Task;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.w3c.dom.Element;

public class Install
extends AbstractCommand {
    public static final String ID = "install";
    protected File file;

    public Install() {
        super(ID);
    }

    public Install(File file) {
        super(ID);
        this.file = file;
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) throws PackageException {
        if (this.file == null) {
            status.addError("Invalid install syntax: No file specified");
        }
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        BundleContext ctx = PackageUpdateComponent.getContext().getBundle().getBundleContext();
        try {
            Bundle bundle = ctx.installBundle(this.file.getAbsolutePath());
            if (bundle.getState() == 1) {
                ctx.installBundle(this.file.getAbsolutePath());
            }
            bundle.start();
        }
        catch (BundleException e) {
            throw new PackageException("Failed to install bundle " + this.file.getName());
        }
        return new Uninstall(this.file);
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        String v = element.getAttribute("file");
        if (v.length() > 0) {
            this.file = new File(v);
            this.guardVars.put("file", this.file);
        }
    }

    @Override
    public void writeTo(XmlWriter writer) {
        writer.start(ID);
        if (this.file != null) {
            writer.attr("file", this.file.getAbsolutePath());
        }
        writer.end();
    }
}

