/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.util;

import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.connect.update.LocalPackage;

public class IOUtils {
    public static File backup(LocalPackage pkg, File file) throws Exception {
        file = file.getCanonicalFile();
        String md5 = IOUtils.createMd5(file.getAbsolutePath());
        File bak = pkg.getData().getEntry("backup");
        bak.mkdirs();
        String name = file.getName();
        File bakFile = new File(bak, md5 + "_" + name);
        FileUtils.copy((File)file, (File)bakFile);
        return bakFile;
    }

    public static String createMd5(String text) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(text.getBytes());
        byte[] hash = digest.digest();
        return IOUtils.md5ToHex(hash);
    }

    public static String createMd5(File file) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        FileInputStream in = new FileInputStream(file);
        byte[] bytes = new byte[65536];
        int r = in.read(bytes);
        while (r > -1) {
            if (r > 0) {
                digest.update(bytes, 0, r);
            }
            r = in.read(bytes);
        }
        byte[] hash = digest.digest();
        return IOUtils.md5ToHex(hash);
    }

    public static String md5ToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

