/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.impl.UpdateServiceImpl;
import org.nuxeo.connect.update.impl.task.AbstractTask;
import org.nuxeo.connect.update.impl.task.Command;
import org.nuxeo.connect.update.impl.task.commands.Flush;
import org.nuxeo.connect.update.impl.xml.XmlWriter;
import org.nuxeo.runtime.api.Framework;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class CommandsTask
extends AbstractTask {
    protected List<Command> commands = new ArrayList<Command>();
    protected LinkedList<Command> log = new LinkedList();

    protected abstract File getCommandsFile() throws PackageException;

    @Override
    public void initialize(LocalPackage pkg, boolean restart) throws PackageException {
        super.initialize(pkg, restart);
        this.loadCommands();
    }

    protected void loadCommands() throws PackageException {
        try {
            String content = this.loadParametrizedFile(this.getCommandsFile(), this.env);
            StringReader reader = new StringReader(content);
            this.readLog(reader);
        }
        catch (IOException e) {
            throw new PackageException("Failed to load commands file", (Throwable)e);
        }
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public List<Command> getCommandLog() {
        return this.log;
    }

    public void addCommand(Command command) {
        this.commands.add(command);
    }

    @Override
    protected void doRun(Map<String, String> params) throws PackageException {
        for (Command cmd : this.commands) {
            Command rollbackCmd = cmd.run(this, params);
            if (rollbackCmd == null) continue;
            if (rollbackCmd.isPostInstall()) {
                this.log.add(rollbackCmd);
                continue;
            }
            this.log.addFirst(rollbackCmd);
        }
        try {
            Flush.flush();
        }
        catch (Exception e) {
            throw new PackageException("cache flushing failed", (Throwable)e);
        }
    }

    @Override
    protected void doRollback() throws PackageException {
        while (!this.log.isEmpty()) {
            this.log.removeFirst().run(this, null);
        }
    }

    @Override
    public void doValidate(ValidationStatus status) throws PackageException {
        String[] platforms = this.pkg.getTargetPlatforms();
        if (platforms != null) {
            for (String platform : platforms) {
            }
        }
        for (Command cmd : this.commands) {
            cmd.validate(this, status);
        }
    }

    public void writeLog(File file) throws PackageException {
        XmlWriter writer = new XmlWriter();
        writer.start("uninstall");
        writer.startContent();
        for (Command cmd : this.log) {
            cmd.writeTo(writer);
        }
        writer.end("uninstall");
        try {
            FileUtils.writeFile((File)file, (String)writer.toString());
        }
        catch (IOException e) {
            throw new PackageException("Failed to write commands", (Throwable)e);
        }
    }

    public void readLog(Reader reader) throws PackageException {
        UpdateServiceImpl reg = (UpdateServiceImpl)Framework.getLocalService(PackageUpdateService.class);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(reader));
            Element root = document.getDocumentElement();
            for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String id = node.getNodeName();
                Command cmd = reg.getCommand(id);
                if (cmd == null) {
                    try {
                        cmd = (Command)this.pkg.getData().loadClass(id).newInstance();
                    }
                    catch (Throwable t) {
                        throw new PackageException("Unknown command: " + id);
                    }
                }
                cmd.initialize(element);
                this.commands.add(cmd);
            }
        }
        catch (Exception e) {
            throw new PackageException("Failed to read commands", (Throwable)e);
        }
    }
}

