/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task.ant;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.nuxeo.connect.update.LocalPackage;

public class AntRunner {
    protected ClassLoader loader;
    protected Project project;
    Map<String, String> globalProperties;

    public AntRunner() {
        this(null);
    }

    public AntRunner(ClassLoader loader) {
        if (loader == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
            loader = this.getClass().getClassLoader();
        }
        this.loader = loader;
    }

    public void setGlobalProperties(Map<String, String> globalProperties) {
        this.globalProperties = globalProperties;
    }

    public Project getProject() {
        return this.project;
    }

    public void run(LocalPackage pkg, File buildFile) throws BuildException {
        this.run(pkg, buildFile, null);
    }

    public void run(LocalPackage pkg, File buildFile, List<String> targets) throws BuildException {
        this.project = new Project();
        this.project.setCoreLoader(this.loader);
        DefaultInputHandler handler = new DefaultInputHandler();
        this.project.setInputHandler((InputHandler)handler);
        this.project.setKeepGoingMode(false);
        this.project.setBaseDir(pkg.getData().getRoot());
        this.project.setUserProperty("ant.file", buildFile.getPath());
        this.project.setUserProperty("ant.version", Main.getAntVersion());
        if (this.globalProperties != null) {
            for (Map.Entry<String, String> entry : this.globalProperties.entrySet()) {
                this.project.setUserProperty(entry.getKey(), entry.getValue());
            }
        }
        this.project.fireBuildStarted();
        try {
            this.project.init();
            ProjectHelper.configureProject((Project)this.project, (File)buildFile);
            if (targets != null) {
                this.project.getExecutor().executeTargets(this.project, targets.toArray(new String[targets.size()]));
            } else {
                this.project.getExecutor().executeTargets(this.project, new String[]{this.project.getDefaultTarget()});
            }
            this.project.fireBuildFinished(null);
        }
        catch (BuildException e) {
            this.project.fireBuildFinished((Throwable)e);
            throw e;
        }
    }
}

