/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task.update;

import java.util.HashSet;
import java.util.Set;
import org.nuxeo.connect.update.util.FileVersion;

public class Version {
    protected String version;
    protected String path;
    protected Set<String> packages;

    public Version(String version) {
        this.version = version;
        this.packages = new HashSet<String>();
    }

    public final Set<String> getPackages() {
        return this.packages;
    }

    public boolean hasPackage(String pkgId) {
        return this.packages.contains(pkgId);
    }

    public boolean removePackage(String pkgId) {
        return this.packages.remove(pkgId);
    }

    public boolean addPackage(String pkgId) {
        return this.packages.add(pkgId);
    }

    public boolean hasPackages() {
        return !this.packages.isEmpty();
    }

    public final String getPath() {
        return this.path;
    }

    public final void setPath(String path) {
        this.path = path;
    }

    public final String getVersion() {
        return this.version;
    }

    public final FileVersion getFileVersion() {
        return new FileVersion(this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Version) {
            return ((Version)obj).version.equals(this.version);
        }
        return false;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return this.version;
    }
}

