/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.impl.task.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.impl.task.UninstallTask;
import org.nuxeo.connect.update.impl.task.commands.AbstractCommand;
import org.nuxeo.connect.update.impl.task.commands.Append;
import org.nuxeo.connect.update.impl.task.commands.Command;
import org.nuxeo.connect.update.impl.xml.XmlWriter;
import org.nuxeo.connect.update.task.Task;
import org.w3c.dom.Element;

public class UnAppend
extends AbstractCommand {
    public static final String ID = "unappend";
    private static final String newLine = System.getProperty("line.separator");
    private File contentToRemove;
    private File fromFile;

    public UnAppend() {
        this(ID);
    }

    protected UnAppend(String id) {
        super(id);
    }

    public UnAppend(File contentToRemove, File fromFile) {
        this(ID);
        this.contentToRemove = contentToRemove;
        this.fromFile = fromFile;
    }

    @Override
    public void writeTo(XmlWriter writer) {
        writer.start(ID);
        if (this.contentToRemove != null) {
            writer.attr("contentToRemove", this.contentToRemove.getAbsolutePath());
        }
        if (this.fromFile != null) {
            writer.attr("fromFile", this.fromFile.getAbsolutePath());
        }
        writer.end();
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        try {
            String lineToCheck;
            BufferedReader brToRemove = new BufferedReader(new FileReader(this.contentToRemove));
            String lineToRemove = brToRemove.readLine();
            BufferedReader brFromFile = new BufferedReader(new FileReader(this.fromFile));
            StringBuilder linesToKeep = new StringBuilder();
            StringBuilder linesToRemove = new StringBuilder();
            boolean found = false;
            while ((lineToCheck = brFromFile.readLine()) != null) {
                if (lineToCheck.equals(lineToRemove)) {
                    found = true;
                    linesToRemove.append(lineToCheck + newLine);
                    lineToRemove = brToRemove.readLine();
                    continue;
                }
                if (lineToRemove != null && found) {
                    found = false;
                    linesToKeep.append(linesToRemove.toString());
                    linesToRemove = new StringBuilder();
                    IOUtils.closeQuietly((Reader)brToRemove);
                    brToRemove = new BufferedReader(new FileReader(this.contentToRemove));
                }
                linesToKeep.append(lineToCheck + newLine);
            }
            if (lineToRemove != null) {
                throw new PackageException("All lines to remove were not found.");
            }
            IOUtils.closeQuietly((Reader)brToRemove);
            IOUtils.closeQuietly((Reader)brFromFile);
            File bak = task instanceof UninstallTask ? null : org.nuxeo.connect.update.util.IOUtils.backup(task.getPackage(), this.contentToRemove);
            FileUtils.writeFile((File)this.fromFile, (String)linesToKeep.toString());
            return new Append(bak, this.fromFile);
        }
        catch (Exception e) {
            throw new PackageException((Throwable)e);
        }
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) throws PackageException {
        if (this.contentToRemove == null || this.fromFile == null) {
            status.addError("Cannot execute command in installer. Invalid unappend syntax: contentToRemove or fromFile was not specified.");
        }
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        String v = element.getAttribute("contentToRemove");
        if (v.length() > 0) {
            this.contentToRemove = new File(v);
        }
        if ((v = element.getAttribute("fromFile")).length() > 0) {
            this.fromFile = new File(v);
        }
    }
}

