/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.jaxrs.test;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4Handler;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public final class JerseyClientHelper {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    public static final Client DEFAULT_CLIENT = JerseyClientHelper.clientBuilder().build();

    private JerseyClientHelper() {
    }

    public static ApacheHttpClientBuilder clientBuilder() {
        return new ApacheHttpClientBuilder();
    }

    public static class ApacheHttpClientBuilder {
        protected int socketTimeout = 60000;
        protected int connectTimeout = 60000;
        protected int connectionRequestTimeout = 60000;
        protected boolean redirectsEnabled = true;
        protected String username;
        protected String password;

        protected ApacheHttpClientBuilder() {
        }

        public ApacheHttpClientBuilder setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public ApacheHttpClientBuilder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ApacheHttpClientBuilder setConnectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public ApacheHttpClientBuilder setRedirectsEnabled(boolean redirectsEnabled) {
            this.redirectsEnabled = redirectsEnabled;
            return this;
        }

        public ApacheHttpClientBuilder setCredentials(String username, String password) {
            this.username = username;
            this.password = password;
            return this;
        }

        public Client build() {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).setConnectionRequestTimeout(this.connectionRequestTimeout).setRedirectsEnabled(this.redirectsEnabled).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
            Client client = new Client((ClientHandler)new ApacheHttpClient4Handler((HttpClient)httpClient, (CookieStore)new BasicCookieStore(), true));
            if (this.username != null && this.password != null) {
                client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username, this.password));
            }
            return client;
        }
    }
}

