/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.groups.audit.service.ExcelExportFactory;
import org.nuxeo.runtime.api.Framework;

@XObject(value="ExcelExport")
public class ExcelExportServiceDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNode(value="@name")
    protected String name;
    @XNode(value="@factoryClass")
    private Class<? extends ExcelExportFactory> factoryClass;
    private File template;

    public String getName() {
        return this.name;
    }

    public File getTemplate() {
        return this.template;
    }

    @XNode(value="@template")
    public void setTemplate(String templatePath) {
        URL templateUrl = ExcelExportServiceDescriptor.class.getResource("/" + templatePath);
        try {
            this.template = Framework.createTempFile((String)"ExcelTemplate", (String)".xls");
            this.template.createNewFile();
            FileUtils.copyURLToFile((URL)templateUrl, (File)this.template);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ExcelExportFactory getFactory() {
        if (this.factoryClass != null) {
            try {
                return this.factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        return null;
    }
}

