/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl.data;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.groups.audit.service.acl.Pair;
import org.nuxeo.ecm.platform.groups.audit.service.acl.filter.IContentFilter;

public class AclSummaryExtractor {
    private static final Log log = LogFactory.getLog(AclSummaryExtractor.class);
    protected IContentFilter filter;

    public AclSummaryExtractor(IContentFilter filter) {
        this.filter = filter;
    }

    public Multimap<String, Pair<String, Boolean>> getAllAclByUser(DocumentModel doc) {
        ACP acp = doc.getACP();
        ACL[] acls = acp.getACLs();
        return this.getAclByUser(acls);
    }

    public Multimap<String, Pair<String, Boolean>> getAclLocalByUser(DocumentModel doc) {
        ACP acp = doc.getACP();
        ACL acl = acp.getACL("local");
        return this.getAclByUser(acl);
    }

    public Multimap<String, Pair<String, Boolean>> getAclInheritedByUser(DocumentModel doc) {
        ACP acp = doc.getACP();
        ACL acl = acp.getACL("inherited");
        return this.getAclByUser(acl);
    }

    public Multimap<String, Pair<String, Boolean>> getAclByUser(ACL[] acls) {
        HashMultimap aclByUser = HashMultimap.create();
        for (ACL acl : acls) {
            this.fillAceByUser((Multimap<String, Pair<String, Boolean>>)aclByUser, acl);
        }
        return aclByUser;
    }

    public Multimap<String, Pair<String, Boolean>> getAclByUser(ACL acl) {
        HashMultimap aclByUser = HashMultimap.create();
        this.fillAceByUser((Multimap<String, Pair<String, Boolean>>)aclByUser, acl);
        return aclByUser;
    }

    protected void fillAceByUser(Multimap<String, Pair<String, Boolean>> aclByUser, ACL acl) {
        if (acl == null) {
            return;
        }
        for (ACE ace : acl.getACEs()) {
            if (!this.filter.acceptsUserOrGroup(ace.getUsername())) continue;
            String userOrGroup = ace.getUsername();
            String permission = ace.getPermission();
            boolean allow = ace.isGranted();
            Pair<String, Boolean> pair = Pair.of(permission, allow);
            aclByUser.put((Object)userOrGroup, pair);
            if (!ace.isGranted() || !ace.isDenied()) continue;
            log.warn((Object)"stupid state: ace granted and denied at the same time. Considered granted");
        }
    }

    public boolean hasLockInheritanceACE(DocumentModel doc) {
        ACL acl = doc.getACP().getOrCreateACL("local");
        for (ACE ace : acl.getACEs()) {
            if (!this.filter.acceptsUserOrGroup(ace.getUsername()) || !this.isLockInheritance(ace)) continue;
            return true;
        }
        return false;
    }

    public boolean hasLockInheritanceACE(Multimap<String, Pair<String, Boolean>> acls) {
        for (String user : acls.keySet()) {
            for (Pair ace : acls.get((Object)user)) {
                if (!"Everyone".equals(user) || !this.filter.acceptsUserOrGroup(user) || !"Everything".equals(ace.a) || ((Boolean)ace.b).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isLockInheritance(ACE ace) {
        return "Everyone".equals(ace.getUsername()) && "Everything".equals(ace.getPermission()) && ace.isDenied();
    }

    public boolean isLockInheritance(String user, Pair<String, Boolean> ace) {
        return "Everyone".equals(user) && "Everything".equals(ace.a) && (Boolean)ace.b == false;
    }

    public Pair<HashSet<String>, HashSet<String>> getAclSummary(DocumentModel doc) {
        ACL[] acls;
        Pair<HashSet<String>, HashSet<String>> summary = this.newSummary();
        ACP acp = doc.getACP();
        for (ACL acl : acls = acp.getACLs()) {
            for (ACE ace : acl.getACEs()) {
                String userOrGroup = ace.getUsername();
                if (!this.filter.acceptsUserOrGroup(userOrGroup)) continue;
                String permission = ace.getPermission();
                ((HashSet)summary.a).add(userOrGroup);
                ((HashSet)summary.b).add(permission);
            }
        }
        return summary;
    }

    protected Pair<HashSet<String>, HashSet<String>> newSummary() {
        return Pair.of(new HashSet(), new HashSet());
    }

    public void printAce(DocumentModel doc) {
        ACL[] acls;
        ACP acp = doc.getACP();
        for (ACL acl : acls = acp.getACLs()) {
            for (ACE ace : acl.getACEs()) {
                System.out.println(ace);
            }
        }
    }
}

