/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl.job.publish;

import java.io.Serializable;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.mail.Mailer;
import org.nuxeo.ecm.automation.core.operations.notification.SendMail;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.groups.audit.service.acl.job.publish.IResultPublisher;
import org.nuxeo.ecm.platform.groups.audit.service.acl.utils.MessageAccessor;
import org.nuxeo.runtime.api.Framework;

public class PublishByMail
implements IResultPublisher {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LogManager.getLogger(PublishByMail.class);
    public static final String PROPERTY_ACLAUDIT_SENDMAIL_CHAIN = "ACL.Audit.SendMail";
    public static final String PROPERTY_MAILFROM = "mail.from";
    public static final String PROPERTY_MAIL_SUBJECT = "message.acl.audit.mail.title";
    public static final String PROPERTY_MAIL_BODY = "message.acl.audit.mail.body";
    public static final String OUTPUT_FILE_NAME = "permissions.xls";
    public static final String FROM = "noreply@nuxeo.com";
    protected String repositoryName;
    protected String to;
    protected String defaultFrom;

    public PublishByMail(String to, String defaultFrom, String repositoryName) {
        this.repositoryName = repositoryName;
        this.to = to;
        this.defaultFrom = defaultFrom;
    }

    @Override
    public void publish(final Blob file) {
        file.setFilename(OUTPUT_FILE_NAME);
        new UnrestrictedSessionRunner(this.repositoryName){

            public void run() {
                DocumentModel docToSend = PublishByMail.this.createDocument(this.session, file, "", "");
                PublishByMail.this.doCallOperationSendMail(this.session, docToSend, PublishByMail.this.to, PublishByMail.this.defaultFrom);
                log.debug("audit sent");
            }
        }.runUnrestricted();
    }

    protected void doCallOperationSendMail(CoreSession session, DocumentModel docToSend, String to, String defaultFrom) {
        String title = MessageAccessor.get(session, PROPERTY_MAIL_SUBJECT);
        String body = MessageAccessor.get(session, PROPERTY_MAIL_BODY);
        String from = Framework.getProperty((String)PROPERTY_MAILFROM, (String)defaultFrom);
        AutomationService automation = (AutomationService)Framework.getService(AutomationService.class);
        try (OperationContext ctx = new OperationContext(session);){
            ctx.setInput((Object)docToSend);
            OperationChain chain = new OperationChain(PROPERTY_ACLAUDIT_SENDMAIL_CHAIN);
            OperationParameters params = chain.add("Document.Mail");
            if (params == null) {
                log.error("failed to retrieve operation {} in chain {}", (Object)"Document.Mail", (Object)chain);
                return;
            }
            params.set("from", (Object)from);
            params.set("to", (Object)to);
            params.set("subject", (Object)title);
            params.set("message", (Object)body);
            String[] str = new String[]{"file:content"};
            params.set("files", (Object)new StringList(str));
            log.debug("Automation run {} for {}", (Object)PROPERTY_ACLAUDIT_SENDMAIL_CHAIN, (Object)to);
            automation.run(ctx, chain);
            log.debug("Automation done {} for {}", (Object)PROPERTY_ACLAUDIT_SENDMAIL_CHAIN, (Object)to);
        }
        catch (OperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected OperationParameters findParameters(OperationChain chain, String id) {
        List params = chain.getOperations();
        for (OperationParameters p : params) {
            if (!p.id().equals(id)) continue;
            return p;
        }
        return null;
    }

    protected DocumentModel createDocument(CoreSession session, Blob blob, String title, String filename) {
        DocumentModel document = session.createDocumentModel("File");
        document.setPropertyValue("file:content", (Serializable)blob);
        document.setPropertyValue("dublincore:title", (Serializable)((Object)title));
        return document;
    }

    protected void logMailerConfiguration() {
        Mailer m = SendMail.COMPOSER.getMailer();
        log.info("mail.smtp.auth:{}", m.getConfiguration().get("mail.smtp.auth"));
        log.info("mail.smtp.starttls.enable:{}", m.getConfiguration().get("mail.smtp.starttls.enable"));
        log.info("mail.smtp.host:{}", m.getConfiguration().get("mail.smtp.host"));
        log.info("mail.smtp.user:{}", m.getConfiguration().get("mail.smtp.user"));
        log.info("mail.smtp.password:{}", m.getConfiguration().get("mail.smtp.password"));
    }
}

